/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.AbstractConnectorAllocator;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import java.util.logging.Level;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;

public class NoTxConnectorAllocator
extends AbstractConnectorAllocator {
    public NoTxConnectorAllocator(PoolManager poolMgr, ManagedConnectionFactory mcf, ResourceSpec spec, Subject subject, ConnectionRequestInfo reqInfo, ClientSecurityInfo info, ConnectorDescriptor desc) {
        super(poolMgr, mcf, spec, subject, reqInfo, info, desc);
    }

    public ResourceHandle createResource() throws PoolingException {
        try {
            ManagedConnection mc = this.mcf.createManagedConnection(this.subject, this.reqInfo);
            ResourceHandle resource = new ResourceHandle(mc, this.spec, this, this.info);
            ConnectionListenerImpl l = new ConnectionListenerImpl(resource);
            mc.addConnectionEventListener((ConnectionEventListener)l);
            return resource;
        }
        catch (ResourceException ex) {
            _logger.log(Level.SEVERE, "poolmgr.create_resource_error", ex);
            if (ex.getLinkedException() != null) {
                _logger.log(Level.SEVERE, "poolmgr.create_resource_error", ex.getLinkedException());
            }
            Log.err.flush();
            throw new PoolingException((Exception)((Object)ex));
        }
    }

    public void fillInResourceObjects(ResourceHandle resource) throws PoolingException {
        try {
            ManagedConnection mc = (ManagedConnection)resource.getResource();
            Object con = mc.getConnection(this.subject, this.reqInfo);
            resource.fillInResourceObjects(con, null);
        }
        catch (ResourceException ex) {
            throw new PoolingException((Exception)((Object)ex));
        }
    }

    public void destroyResource(ResourceHandle resource) throws PoolingException {
        try {
            ManagedConnection mc = (ManagedConnection)resource.getResource();
            mc.destroy();
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, ex.getMessage());
            throw new PoolingException(ex);
        }
    }

    public boolean isTransactional() {
        return false;
    }

    class ConnectionListenerImpl
    implements ConnectionEventListener {
        private ResourceHandle resource;

        public ConnectionListenerImpl(ResourceHandle resource) {
            this.resource = resource;
        }

        public void connectionClosed(ConnectionEvent evt) {
            NoTxConnectorAllocator.this.poolMgr.putbackResourceToPool(this.resource, false);
        }

        public void connectionErrorOccurred(ConnectionEvent evt) {
            ManagedConnection mc = (ManagedConnection)evt.getSource();
            mc.removeConnectionEventListener((ConnectionEventListener)this);
            NoTxConnectorAllocator.this.poolMgr.putbackResourceToPool(this.resource, true);
            try {
                mc.destroy();
            }
            catch (ResourceException resourceException) {
                // empty catch block
            }
            this.resource.setConnectionErrorOccurred();
        }

        public void localTransactionStarted(ConnectionEvent evt) {
            throw new IllegalStateException("local transaction not supported");
        }

        public void localTransactionCommitted(ConnectionEvent evt) {
            throw new IllegalStateException("local transaction not supported");
        }

        public void localTransactionRolledback(ConnectionEvent evt) {
            throw new IllegalStateException("local transaction not supported");
        }
    }
}

