/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics;

import com.sun.enterprise.diagnostics.Constants;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.ExecutionContext;
import com.sun.enterprise.diagnostics.TargetResolver;
import com.sun.enterprise.diagnostics.TargetType;
import java.io.File;
import java.util.logging.Level;

public class PELocalTargetResolver
extends TargetResolver {
    public PELocalTargetResolver(String target, String repositoryDir, boolean local) {
        super(target, repositoryDir, local);
    }

    public boolean validateTarget() throws DiagnosticException {
        if (this.repositoryDir != null && this.target != null) {
            this.logger.log(Level.FINEST, "validate_local_target", new String[]{this.target, this.repositoryDir});
            return this.isAInstance(this.repositoryDir, this.target);
        }
        throw new DiagnosticException("Targetdir and targetname are null");
    }

    private boolean isAInstance(String repositoryDir, String target) {
        if (repositoryDir != null && target != null) {
            String absoluteDir = repositoryDir + File.separator + target;
            File applicationsDirObj = new File(absoluteDir + Constants.APPLICATIONS_DIR);
            File generatedDirObj = new File(absoluteDir + Constants.GENERATED_DIR);
            File configDirObj = new File(absoluteDir + Constants.CONFIG_DIR);
            return applicationsDirObj.exists() && generatedDirObj.exists() && configDirObj.exists();
        }
        return false;
    }

    protected void determineRepositoryDetails() {
        this.repositoryName = this.target;
    }

    protected void setExecutionContext() {
        this.context = ExecutionContext.LOCAL_EC;
    }

    protected void determineTargetType() {
        if (this.type == null) {
            this.setTargetType(TargetType.DAS);
        }
    }

    protected void determineTargetDir() {
    }

    protected void determineInstances() {
        this.addInstance(TargetType.DAS.getType());
    }
}

