/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient;

import com.sun.enterprise.appclient.MainWithModuleSupport;
import com.sun.enterprise.appclient.PersistenceUnitLoaderImpl;
import com.sun.enterprise.appclient.jws.Util;
import com.sun.enterprise.appclient.jws.boot.JWSACCMain;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.annotation.AnnotationProcessorException;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.util.AnnotationDetector;
import com.sun.enterprise.deployment.util.AppClientPersistenceDependencyAnnotationDetector;
import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.enterprise.loader.InstrumentableClassLoader;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AppClientInfo {
    public static final String USER_CODE_IS_SIGNED_PROPERTYNAME = "com.sun.aas.user.code.signed";
    private static final String SIGNED_USER_CODE_PERMISSION_TEMPLATE_NAME = "jwsclientSigned.policy";
    private static final String UNSIGNED_USER_CODE_PERMISSION_TEMPLATE_NAME = "jwsclientUnsigned.policy";
    private static final String CODE_BASE_PLACEHOLDER_NAME = "com.sun.aas.jws.client.codeBase";
    protected Logger _logger;
    private AbstractArchive appClientArchive = null;
    private File appClientFile = null;
    private Archivist archivist = null;
    protected String mainClassFromCommandLine;
    protected String mainClassNameToRun = null;
    private ClassLoader classLoader = null;
    protected boolean isJWS = false;
    protected PersistenceUnitLoaderImpl puLoader = null;
    protected StringManager localStrings = StringManager.getManager(MainWithModuleSupport.class);
    protected static final boolean _keepExplodedDir = Boolean.getBoolean("appclient.keep.exploded.dir");

    public AppClientInfo(boolean isJWS, Logger logger, File appClientFile, Archivist archivist, String mainClassFromCommandLine) {
        this.isJWS = isJWS;
        this._logger = logger;
        this.appClientFile = appClientFile;
        this.archivist = archivist;
        this.mainClassFromCommandLine = mainClassFromCommandLine;
    }

    protected void completeInit() throws IOException, SAXParseException, ClassNotFoundException, URISyntaxException, AnnotationProcessorException, Exception {
        this.appClientArchive = this.expand(this.appClientFile);
        this.classLoader = this.createClassLoader(this.appClientArchive);
        RootDeploymentDescriptor descriptor = this.populateDescriptor(this.appClientArchive, this.archivist, this.classLoader);
        if (this.appClientDependsOnPersistenceUnit(this.getAppClient())) {
            this.handlePersistenceUnitDependency();
        }
        this.archivist.validate(this.classLoader);
        this.fixupWSDLEntries();
        if (this.isJWS) {
            this.grantRequestedPermissionsToUserCode();
        }
    }

    protected ApplicationClientDescriptor getAppClient() {
        return this.getAppClient(this.archivist);
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected File createTmpArchiveDir(File forArchive) throws IOException {
        String name = forArchive.getName();
        File tmpDir = File.createTempFile("acc-" + name, "");
        tmpDir.delete();
        tmpDir.mkdirs();
        if (!_keepExplodedDir) {
            tmpDir.deleteOnExit();
        }
        return tmpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() throws IOException {
        try {
            if (this.puLoader != null) {
                this.puLoader.unload();
                this.puLoader = null;
            }
            if (this.appClientArchive != null) {
                this.appClientArchive.close();
            }
            if (this.classLoader != null && this.classLoader instanceof EJBClassLoader) {
                ((EJBClassLoader)this.classLoader).done();
            }
        }
        finally {
            if (this.deleteAppClientDir() && this.appClientArchive != null) {
                this.deleteFile(new File(this.appClientArchive.getArchiveUri()));
            }
            this.appClientArchive = null;
        }
    }

    protected boolean deleteAppClientDir() {
        return !_keepExplodedDir;
    }

    private void handlePersistenceUnitDependency() throws URISyntaxException, MalformedURLException, ClassNotFoundException, IOException {
        InstrumentableClassLoader classLoader = (InstrumentableClassLoader)((Object)this.getClassLoader());
        this.puLoader = new PersistenceUnitLoaderImpl(this.appClientArchive.getArchiveUri(), classLoader, this.getAppClient());
        this.puLoader.load();
    }

    private ClassLoader createClassLoader(AbstractArchive archive) throws IOException {
        int i;
        List<String> paths = this.getClassPaths(archive);
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        EJBClassLoader loader = new EJBClassLoader(parent);
        int LIST_SZ = paths.size();
        for (i = 0; i < LIST_SZ; ++i) {
            String path = paths.get(i);
            loader.appendURL(new File(path));
        }
        if (this._logger.isLoggable(Level.FINE)) {
            for (i = 0; i < paths.size(); ++i) {
                this._logger.fine("Added path to classloader ==> " + paths.get(i));
            }
        }
        return loader;
    }

    private void deleteFile(File f) {
        if (f.isDirectory()) {
            for (File subFile : f.listFiles()) {
                this.deleteFile(subFile);
            }
        }
        f.delete();
    }

    private boolean appClientDependsOnPersistenceUnit(ApplicationClientDescriptor acDescr) throws MalformedURLException, ClassNotFoundException, IOException, URISyntaxException {
        return this.descriptorContainsPURefcs(acDescr) || this.mainClassContainsPURefcAnnotations(acDescr);
    }

    private boolean descriptorContainsPURefcs(ApplicationClientDescriptor descr) {
        return !descr.getEntityManagerFactoryReferenceDescriptors().isEmpty();
    }

    private boolean mainClassContainsPURefcAnnotations(ApplicationClientDescriptor acDescr) throws MalformedURLException, ClassNotFoundException, IOException, URISyntaxException {
        AppClientPersistenceDependencyAnnotationDetector annoDetector = new AppClientPersistenceDependencyAnnotationDetector();
        String mainClassEntryName = acDescr.getMainClassName().replace('.', '/') + ".class";
        return this.classContainsAnnotation(mainClassEntryName, annoDetector, this.appClientArchive, acDescr);
    }

    private void fixupWSDLEntries() throws URISyntaxException, MalformedURLException, IOException, AnnotationProcessorException {
        ApplicationClientDescriptor ac = this.getAppClient();
        URI uri = new File(this.getAppClientRoot(this.appClientArchive, ac)).toURI();
        File moduleFile = new File(uri);
        for (ServiceReferenceDescriptor serviceRef : ac.getServiceReferenceDescriptors()) {
            if (serviceRef.getWsdlFileUri() == null) continue;
            URI wsdlURI = new URI(serviceRef.getWsdlFileUri());
            File wsdlFile = new File(serviceRef.getWsdlFileUri());
            if (wsdlFile.isAbsolute()) {
                serviceRef.setWsdlFileUrl(wsdlFile.toURI().toURL());
                continue;
            }
            serviceRef.setWsdlFileUrl(FileUtil.getEntryAsUrl(moduleFile, serviceRef.getWsdlFileUri()));
        }
    }

    private RootDeploymentDescriptor populateDescriptor(AbstractArchive archive, Archivist theArchivist, ClassLoader loader) throws IOException, SAXParseException, Exception {
        theArchivist.setAnnotationProcessingRequested(true);
        theArchivist.setClassLoader(loader);
        RootDeploymentDescriptor d = null;
        try {
            d = theArchivist.open(archive);
        }
        catch (Exception ex) {
            this.close();
            throw ex;
        }
        this.messageDescriptor(d, theArchivist, archive);
        theArchivist.setDescriptor(d);
        return d;
    }

    private void grantRequestedPermissionsToUserCode() throws IOException, URISyntaxException {
        boolean userJarIsSigned = Boolean.getBoolean(USER_CODE_IS_SIGNED_PROPERTYNAME);
        boolean retainTempFiles = Boolean.getBoolean("com.sun.aas.jws.retainTempFiles");
        String templateName = userJarIsSigned ? SIGNED_USER_CODE_PERMISSION_TEMPLATE_NAME : UNSIGNED_USER_CODE_PERMISSION_TEMPLATE_NAME;
        String template = Util.loadResource(JWSACCMain.class, templateName);
        File policyFile = File.createTempFile("accjws-user", ".policy");
        if (!retainTempFiles) {
            policyFile.deleteOnExit();
        }
        PrintStream ps = new PrintStream(policyFile);
        Properties p = new Properties();
        EJBClassLoader loader = (EJBClassLoader)this.getClassLoader();
        for (URL classPathElement : loader.getURLs()) {
            String codeBase = Util.URLtoCodeBase(classPathElement);
            if (codeBase == null) continue;
            p.setProperty(CODE_BASE_PLACEHOLDER_NAME, codeBase);
            String policyPart = Util.replaceTokens(template, p);
            ps.println(policyPart);
        }
        ps.close();
        JWSACCMain.refreshPolicy((File)policyFile);
        if (!retainTempFiles) {
            policyFile.delete();
        }
    }

    protected abstract AbstractArchive expand(File var1) throws IOException, Exception;

    protected ApplicationClientDescriptor getAppClient(Archivist archivist) {
        return (ApplicationClientDescriptor)ApplicationClientDescriptor.class.cast(archivist.getDescriptor());
    }

    protected String getAppClientRoot(AbstractArchive archive, ApplicationClientDescriptor descriptor) {
        return archive.getArchiveUri();
    }

    protected void messageDescriptor(RootDeploymentDescriptor d, Archivist archivist, AbstractArchive archive) throws IOException, AnnotationProcessorException {
    }

    protected List<String> getClassPaths(AbstractArchive archive) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(archive.getArchiveUri());
        return paths;
    }

    protected String getMainClassNameToRun(ApplicationClientDescriptor acDescr) {
        if (this.mainClassNameToRun == null) {
            if (this.mainClassFromCommandLine != null) {
                this.mainClassNameToRun = this.mainClassFromCommandLine;
                this._logger.fine("Main class is " + this.mainClassNameToRun + " from command line");
            } else {
                this.mainClassNameToRun = this.getAppClient().getMainClassName();
                this._logger.fine("Main class is " + this.mainClassNameToRun + " from descriptor");
            }
        }
        return this.mainClassNameToRun;
    }

    protected boolean classContainsAnnotation(String entry, AnnotationDetector detector, AbstractArchive archive, ApplicationClientDescriptor descriptor) throws FileNotFoundException, IOException {
        String acRoot = this.getAppClientRoot(archive, descriptor);
        String entryLocation = acRoot + File.separator + entry;
        File entryFile = new File(entryLocation);
        return detector.containsAnnotation(entryFile);
    }

    public String toString() {
        String lineSep = System.getProperty("line.separator");
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + ": " + lineSep);
        result.append("  isJWS: " + this.isJWS);
        result.append("  archive file: " + this.appClientFile.getAbsolutePath() + lineSep);
        result.append("  archive type: " + this.appClientArchive.getClass().getName() + lineSep);
        result.append("  archivist type: " + this.archivist.getClass().getName() + lineSep);
        result.append("  main class to be run: " + this.mainClassNameToRun + lineSep);
        result.append("  temporary archive directory: " + this.appClientArchive.getArchiveUri() + lineSep);
        result.append("  class loader type: " + this.classLoader.getClass().getName() + lineSep);
        return result.toString();
    }
}

