/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.jmx;

import com.sun.enterprise.admin.server.core.jmx.Introspector;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;

public class MBeanIntrospector
extends Introspector {
    private boolean mIsStandard;
    private boolean mIsDynamic;
    private Class mMBeanInterfaceClass;

    public MBeanIntrospector(Class c) throws NotCompliantMBeanException {
        super(c);
        this.checkBasic(c);
        this.checkMBeanType(c);
        this.checkCompliance();
    }

    public boolean isStandardMBean() {
        return this.mIsStandard;
    }

    public boolean isDynamicMBean() {
        return this.mIsDynamic;
    }

    public Class getMBeanInterfaceClass() {
        return this.mMBeanInterfaceClass;
    }

    public boolean isSupported(String methodName, Class[] signature) {
        boolean isSupported = false;
        try {
            Method m = this.mMBeanInterfaceClass.getMethod(methodName, signature);
            isSupported = m != null;
        }
        catch (Exception e) {
            // empty catch block
        }
        return isSupported;
    }

    private void checkBasic(Class c) throws NotCompliantMBeanException {
        if (!this.isInstantiableJavaClass(c)) {
            throw new NotCompliantMBeanException();
        }
    }

    private void checkMBeanType(Class c) {
        Class superClass;
        boolean isStandard = this.isStandard(c);
        boolean isDynamic = this.isDynamic(c);
        if (!isStandard && !isDynamic && (superClass = c.getSuperclass()) != null && superClass != Object.class) {
            this.checkMBeanType(superClass);
        }
        if (isStandard) {
            this.mIsStandard = true;
            this.setStandardMBeanInterface(c);
        }
        if (isDynamic) {
            this.mIsDynamic = true;
            this.setDynamicMBeanInterface();
        }
    }

    private void checkCompliance() throws NotCompliantMBeanException {
        if (!this.mIsStandard && !this.mIsDynamic || this.mIsStandard && this.mIsDynamic) {
            throw new NotCompliantMBeanException();
        }
    }

    private void setStandardMBeanInterface(Class c) {
        String className = this.deriveStandardMBeanIntfClassName(c);
        this.mMBeanInterfaceClass = this.getImplementedMBeanClass(c, className);
    }

    private void setDynamicMBeanInterface() {
        this.mMBeanInterfaceClass = DynamicMBean.class;
    }

    private boolean isStandard(Class c) {
        boolean isStandard = false;
        String className = this.deriveStandardMBeanIntfClassName(c);
        if (this.getImplementedMBeanClass(c, className) != null) {
            isStandard = true;
        }
        return isStandard;
    }

    private boolean isDynamic(Class c) {
        boolean isDynamic = false;
        Class<?>[] interfaces = c.getInterfaces();
        int length = interfaces.length;
        for (int i = 0; i < length; ++i) {
            if (interfaces[i] != DynamicMBean.class) continue;
            isDynamic = true;
            break;
        }
        return isDynamic;
    }

    private boolean isInstantiableJavaClass(Class c) {
        boolean isInstantiable = false;
        if (!c.isPrimitive() && !c.isArray()) {
            int modifiers = c.getModifiers();
            boolean isInterface = Modifier.isInterface(modifiers);
            boolean isAbstract = Modifier.isAbstract(modifiers);
            isInstantiable = !isInterface && !isAbstract;
        }
        return isInstantiable;
    }

    private String deriveStandardMBeanIntfClassName(Class c) {
        String className = this.truncateClassName(c);
        return className + "MBean";
    }

    private String truncateClassName(Class c) {
        String className = c.getName();
        int lastDot = className.lastIndexOf(46);
        className = className.substring(lastDot + 1);
        return className;
    }

    private Class getImplementedMBeanClass(Class c, String intfName) {
        Class<?> implementedMBean = null;
        Class<?>[] interfaces = c.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            String className = this.truncateClassName(interfaces[i]);
            if (!className.equals(intfName)) continue;
            implementedMBean = interfaces[i];
            break;
        }
        return implementedMBean;
    }

    private final String convertToCamelCase(String str) {
        String camelCase = "";
        char c = str.charAt(0);
        camelCase = camelCase + Character.toUpperCase(c);
        if (str.length() > 1) {
            camelCase = camelCase + str.substring(1);
        }
        return camelCase;
    }
}

