/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.selfmanagement.event;

import com.sun.enterprise.admin.selfmanagement.event.Event;
import com.sun.enterprise.admin.selfmanagement.event.EventAbstractFactory;
import com.sun.enterprise.admin.selfmanagement.event.EventBuilder;
import com.sun.enterprise.admin.selfmanagement.event.TimerEvent;
import com.sun.enterprise.admin.selfmanagement.event.TimerEventFilter;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.timer.Timer;

public class TimerEventFactory
extends EventAbstractFactory {
    private static TimerEventFactory instance = new TimerEventFactory();
    private static final String defaultPattern = "MM/dd/yyyy HH:mm:ss";
    private static Timer timer = null;

    TimerEventFactory() {
        EventBuilder.getInstance().addEventFactory("timer", this);
    }

    public Event instrumentEvent(ElementProperty[] properties, String description) {
        String datePattern = null;
        String dateString = null;
        long period = 0L;
        long numberOfOccurrences = 0L;
        String message = "timer notification";
        String type = "timer";
        Object format = null;
        for (int i = 0; i < properties.length; ++i) {
            ElementProperty property = properties[i];
            String propertyName = property.getName().toLowerCase();
            if (propertyName.equals("pattern")) {
                datePattern = property.getValue();
            }
            if (propertyName.equals("datestring")) {
                dateString = property.getValue();
            }
            if (propertyName.equals("period")) {
                period = Long.parseLong(property.getValue());
            }
            if (propertyName.equals("numberofoccurrences")) {
                numberOfOccurrences = Long.parseLong(property.getValue());
            }
            if (!propertyName.equals("message")) continue;
            message = property.getValue();
        }
        if (datePattern == null) {
            datePattern = defaultPattern;
        }
        Date d = null;
        try {
            d = dateString == null ? new Date() : new SimpleDateFormat(datePattern).parse(dateString);
        }
        catch (ParseException pex) {
            throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "dateString", "timer"), pex);
        }
        Integer id = 0;
        id = period > 0L ? (numberOfOccurrences > 0L ? this.getTimer().addNotification(type, message, null, d, period, numberOfOccurrences) : this.getTimer().addNotification(type, message, null, d, period)) : this.getTimer().addNotification(type, message, null, d);
        return new TimerEvent(id, new TimerEventFilter(id), description);
    }

    void removeEvent(int id) {
        try {
            this.getTimer().removeNotification(id);
        }
        catch (InstanceNotFoundException iex) {
            _logger.log(Level.WARNING, "smgt.internal_error", iex);
        }
    }

    private synchronized Timer getTimer() {
        if (timer != null) {
            return timer;
        }
        try {
            timer = (Timer)this.getMBeanServer().instantiate("javax.management.timer.Timer");
            this.getMBeanServer().registerMBean(timer, TimerEvent.getTimerObjectName());
            timer.start();
            return timer;
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "smgt.internal_error", ex);
            return timer;
        }
    }

    static TimerEventFactory getInstance() {
        return instance;
    }
}

