/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventListener;
import com.sun.enterprise.admin.event.AdminEventMulticaster;
import com.sun.enterprise.admin.event.ApplicationDeployEvent;
import com.sun.enterprise.admin.event.ApplicationDeployEventListener;
import com.sun.enterprise.admin.event.AuditModuleEvent;
import com.sun.enterprise.admin.event.AuditModuleEventListener;
import com.sun.enterprise.admin.event.AuthRealmEvent;
import com.sun.enterprise.admin.event.AuthRealmEventListener;
import com.sun.enterprise.admin.event.BaseDeployEvent;
import com.sun.enterprise.admin.event.BaseDeployEventListener;
import com.sun.enterprise.admin.event.ClusterEvent;
import com.sun.enterprise.admin.event.ClusterEventListener;
import com.sun.enterprise.admin.event.ConfigChangeCategory;
import com.sun.enterprise.admin.event.ConfigChangeEvent;
import com.sun.enterprise.admin.event.ConfigChangeEventListener;
import com.sun.enterprise.admin.event.DynamicReconfigEvent;
import com.sun.enterprise.admin.event.DynamicReconfigEventListener;
import com.sun.enterprise.admin.event.EjbTimerEvent;
import com.sun.enterprise.admin.event.EjbTimerEventListener;
import com.sun.enterprise.admin.event.ElementChangeEvent;
import com.sun.enterprise.admin.event.ElementChangeEventListener;
import com.sun.enterprise.admin.event.LogLevelChangeEvent;
import com.sun.enterprise.admin.event.LogLevelChangeEventListener;
import com.sun.enterprise.admin.event.MBeanElementChangeEvent;
import com.sun.enterprise.admin.event.MBeanElementChangeEventListener;
import com.sun.enterprise.admin.event.ModuleDeployEvent;
import com.sun.enterprise.admin.event.ModuleDeployEventListener;
import com.sun.enterprise.admin.event.MonitoringEvent;
import com.sun.enterprise.admin.event.MonitoringEventListener;
import com.sun.enterprise.admin.event.MonitoringLevelChangeEvent;
import com.sun.enterprise.admin.event.MonitoringLevelChangeEventListener;
import com.sun.enterprise.admin.event.ResourceDeployEvent;
import com.sun.enterprise.admin.event.ResourceDeployEventListener;
import com.sun.enterprise.admin.event.SecurityServiceEvent;
import com.sun.enterprise.admin.event.SecurityServiceEventListener;
import com.sun.enterprise.admin.event.ShutdownEvent;
import com.sun.enterprise.admin.event.ShutdownEventListener;
import com.sun.enterprise.admin.event.UserMgmtEvent;
import com.sun.enterprise.admin.event.UserMgmtEventListener;
import com.sun.enterprise.admin.event.availability.AvailabilityServiceEvent;
import com.sun.enterprise.admin.event.availability.AvailabilityServiceEventListener;
import com.sun.enterprise.admin.event.http.HSAccessLogEvent;
import com.sun.enterprise.admin.event.http.HSAccessLogEventListener;
import com.sun.enterprise.admin.event.http.HSHttpAccessLogEvent;
import com.sun.enterprise.admin.event.http.HSHttpAccessLogEventListener;
import com.sun.enterprise.admin.event.http.HSHttpListenerEvent;
import com.sun.enterprise.admin.event.http.HSHttpListenerEventListener;
import com.sun.enterprise.admin.event.http.HSServiceEvent;
import com.sun.enterprise.admin.event.http.HSServiceEventListener;
import com.sun.enterprise.admin.event.http.HSSslEvent;
import com.sun.enterprise.admin.event.http.HSSslEventListener;
import com.sun.enterprise.admin.event.http.HSVirtualServerEvent;
import com.sun.enterprise.admin.event.http.HSVirtualServerEventListener;
import com.sun.enterprise.admin.event.jms.JmsHostEvent;
import com.sun.enterprise.admin.event.jms.JmsHostEventListener;
import com.sun.enterprise.admin.event.jms.JmsServiceEvent;
import com.sun.enterprise.admin.event.jms.JmsServiceEventListener;
import com.sun.enterprise.admin.event.log.LogServiceEvent;
import com.sun.enterprise.admin.event.log.LogServiceEventListener;
import com.sun.enterprise.admin.event.selfmanagement.ManagementRuleEvent;
import com.sun.enterprise.admin.event.selfmanagement.ManagementRuleEventListener;
import com.sun.enterprise.admin.event.tx.JTSEvent;
import com.sun.enterprise.admin.event.tx.JTSEventListener;
import com.sun.enterprise.admin.event.tx.TransactionsRecoveryEvent;
import com.sun.enterprise.admin.event.tx.TransactionsRecoveryEventListener;
import com.sun.enterprise.admin.event.wsmgmt.RegistryLocationEvent;
import com.sun.enterprise.admin.event.wsmgmt.RegistryLocationEventListener;
import com.sun.enterprise.admin.event.wsmgmt.TransformationRuleEvent;
import com.sun.enterprise.admin.event.wsmgmt.TransformationRuleEventListener;
import com.sun.enterprise.admin.event.wsmgmt.WebServiceEndpointEvent;
import com.sun.enterprise.admin.event.wsmgmt.WebServiceEndpointEventListener;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.HashMap;

public class AdminEventListenerRegistry {
    static final String notificationEventType = "javax.management.Notification";
    private static HashMap listenerMap = null;
    private static StringManager localStrings;

    public static void addBaseDeployEventListener(BaseDeployEventListener listener) {
        AdminEventMulticaster.addListener(BaseDeployEvent.eventType, listener);
    }

    public static void addApplicationDeployEventListener(ApplicationDeployEventListener listener) {
        AdminEventMulticaster.addListener(ApplicationDeployEvent.eventType, listener);
    }

    public static void addModuleDeployEventListener(ModuleDeployEventListener listener) {
        AdminEventMulticaster.addListener(ModuleDeployEvent.eventType, listener);
    }

    public static void addResourceDeployEventListener(ResourceDeployEventListener listener) {
        AdminEventMulticaster.addListener(ResourceDeployEvent.eventType, listener);
    }

    public static void addConfigChangeEventListener(ConfigChangeEventListener listener) {
        AdminEventMulticaster.addListener(ConfigChangeEvent.eventType, listener);
    }

    public static void addMonitoringEventListener(MonitoringEventListener listener) {
        AdminEventMulticaster.addListener(MonitoringEvent.eventType, listener);
    }

    public static void removeEventListener(AdminEventListener listener) {
        AdminEventMulticaster.removeListener(listener);
    }

    public static void addConfigChangeEventListener(ConfigChangeCategory category, ConfigChangeEventListener listener) {
        AdminEventMulticaster.addListener(ConfigChangeEvent.eventType, category, listener);
    }

    public static void addLogLevelChangeEventListener(LogLevelChangeEventListener listener) {
        AdminEventMulticaster.addListener(LogLevelChangeEvent.eventType, listener);
    }

    public static void addElementChangeEventListener(ElementChangeEventListener listener) {
        AdminEventMulticaster.addListener(ElementChangeEvent.eventType, listener);
    }

    public static void addSecurityServiceEventListener(SecurityServiceEventListener listener) {
        AdminEventMulticaster.addListener(SecurityServiceEvent.eventType, listener);
    }

    public static void addAuditModuleEventListener(AuditModuleEventListener listener) {
        AdminEventMulticaster.addListener(AuditModuleEvent.eventType, listener);
    }

    public static void addAuthRealmEventListener(AuthRealmEventListener listener) {
        AdminEventMulticaster.addListener(AuthRealmEvent.eventType, listener);
    }

    public static void addUserMgmtEventListener(UserMgmtEventListener listener) {
        AdminEventMulticaster.addListener(UserMgmtEvent.eventType, listener);
    }

    public static void addEjbTimerEventListener(EjbTimerEventListener listener) {
        AdminEventMulticaster.addListener(EjbTimerEvent.eventType, listener);
    }

    public static void addMonitoringLevelChangeEventListener(MonitoringLevelChangeEventListener listener) {
        AdminEventMulticaster.addListener(MonitoringLevelChangeEvent.eventType, listener);
    }

    public static void addShutdownEventListener(ShutdownEventListener listener) {
        AdminEventMulticaster.addListener(ShutdownEvent.eventType, listener);
    }

    public static void addEventListener(String eventType, AdminEventListener listener) {
        AdminEventListenerRegistry.validateRegistration(eventType, listener);
        AdminEventMulticaster.addListener(eventType, listener);
    }

    private static void validateRegistration(String eventType, AdminEventListener listener) {
        if (eventType == null || listener == null) {
            String msg = localStrings.getString("admin.null_not_supported");
            throw new IllegalArgumentException(msg);
        }
        Class listenerImplClass = (Class)listenerMap.get(eventType);
        if (listenerImplClass == null) {
            String msg = localStrings.getString("admin.event.invalid_event_type", eventType);
            throw new IllegalArgumentException(msg);
        }
        Class<?>[] classes = listener.getClass().getInterfaces();
        if (classes == null) {
            String msg = localStrings.getString("admin.event.does_not_implement", listener.getClass().getName());
            throw new IllegalArgumentException(msg);
        }
        boolean found = false;
        for (int i = 0; i < classes.length; ++i) {
            String cName = classes[i].getName();
            if (cName == null || !cName.equals(listenerImplClass.getName())) continue;
            found = true;
            break;
        }
        if (!found) {
            String msg = localStrings.getString("admin.event.not_compatible", eventType, listenerImplClass.getName(), listener.getClass().getName());
            throw new IllegalArgumentException();
        }
    }

    static {
        listenerMap = new HashMap();
        listenerMap.put(AdminEvent.eventType, AdminEventListener.class);
        listenerMap.put(ConfigChangeEvent.eventType, ConfigChangeEventListener.class);
        listenerMap.put(MonitoringEvent.eventType, MonitoringEventListener.class);
        listenerMap.put(ShutdownEvent.eventType, ShutdownEventListener.class);
        listenerMap.put(BaseDeployEvent.eventType, BaseDeployEventListener.class);
        listenerMap.put(ApplicationDeployEvent.eventType, ApplicationDeployEventListener.class);
        listenerMap.put(ModuleDeployEvent.eventType, ModuleDeployEventListener.class);
        listenerMap.put(ResourceDeployEvent.eventType, ResourceDeployEventListener.class);
        listenerMap.put(LogLevelChangeEvent.eventType, LogLevelChangeEventListener.class);
        listenerMap.put(MonitoringLevelChangeEvent.eventType, MonitoringLevelChangeEventListener.class);
        listenerMap.put(AvailabilityServiceEvent.eventType, AvailabilityServiceEventListener.class);
        listenerMap.put(AuthRealmEvent.eventType, AuthRealmEventListener.class);
        listenerMap.put(AuditModuleEvent.eventType, AuditModuleEventListener.class);
        listenerMap.put(SecurityServiceEvent.eventType, SecurityServiceEventListener.class);
        listenerMap.put(ElementChangeEvent.eventType, ElementChangeEventListener.class);
        listenerMap.put(UserMgmtEvent.eventType, UserMgmtEventListener.class);
        listenerMap.put(EjbTimerEvent.eventType, EjbTimerEventListener.class);
        listenerMap.put(HSServiceEvent.eventType, HSServiceEventListener.class);
        listenerMap.put(HSAccessLogEvent.eventType, HSAccessLogEventListener.class);
        listenerMap.put(HSHttpAccessLogEvent.eventType, HSHttpAccessLogEventListener.class);
        listenerMap.put(HSHttpListenerEvent.eventType, HSHttpListenerEventListener.class);
        listenerMap.put(HSSslEvent.eventType, HSSslEventListener.class);
        listenerMap.put(HSVirtualServerEvent.eventType, HSVirtualServerEventListener.class);
        listenerMap.put(JmsServiceEvent.eventType, JmsServiceEventListener.class);
        listenerMap.put(JmsHostEvent.eventType, JmsHostEventListener.class);
        listenerMap.put(LogServiceEvent.eventType, LogServiceEventListener.class);
        listenerMap.put(DynamicReconfigEvent.eventType, DynamicReconfigEventListener.class);
        listenerMap.put(TransactionsRecoveryEvent.eventType, TransactionsRecoveryEventListener.class);
        listenerMap.put(JTSEvent.eventType, JTSEventListener.class);
        listenerMap.put(WebServiceEndpointEvent.eventType, WebServiceEndpointEventListener.class);
        listenerMap.put(TransformationRuleEvent.eventType, TransformationRuleEventListener.class);
        listenerMap.put(RegistryLocationEvent.eventType, RegistryLocationEventListener.class);
        listenerMap.put(MBeanElementChangeEvent.EVENT_TYPE, MBeanElementChangeEventListener.class);
        listenerMap.put(ManagementRuleEvent.eventType, ManagementRuleEventListener.class);
        listenerMap.put(ClusterEvent.eventType, ClusterEventListener.class);
        localStrings = StringManager.getManager(AdminEventListenerRegistry.class);
    }
}

