/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.NotLocalLocalCRDImpl;
import com.sun.corba.ee.impl.transport.CorbaContactInfoListIteratorImpl;
import com.sun.corba.ee.impl.transport.SharedCDRContactInfoImpl;
import com.sun.corba.ee.impl.transport.SocketOrChannelContactInfoImpl;
import com.sun.corba.ee.pept.transport.ContactInfo;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfile;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.protocol.LocalClientRequestDispatcher;
import com.sun.corba.ee.spi.protocol.LocalClientRequestDispatcherFactory;
import com.sun.corba.ee.spi.transport.CorbaContactInfoList;
import com.sun.corba.ee.spi.transport.SocketInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CorbaContactInfoListImpl
implements CorbaContactInfoList {
    protected ORB orb;
    protected LocalClientRequestDispatcher LocalClientRequestDispatcher;
    protected IOR targetIOR;
    protected IOR effectiveTargetIOR;
    protected List effectiveTargetIORContactInfoList;
    protected boolean isCachedHashValue = false;
    protected int cachedHashValue;
    protected ContactInfo primaryContactInfo;

    public CorbaContactInfoListImpl(ORB orb) {
        this.orb = orb;
    }

    public CorbaContactInfoListImpl(ORB orb, IOR targetIOR) {
        this(orb);
        this.setTargetIOR(targetIOR);
    }

    public synchronized Iterator iterator() {
        this.createContactInfoList();
        return new CorbaContactInfoListIteratorImpl(this.orb, this, this.primaryContactInfo, this.effectiveTargetIORContactInfoList);
    }

    public synchronized void setTargetIOR(IOR targetIOR) {
        this.targetIOR = targetIOR;
        this.setEffectiveTargetIOR(targetIOR);
        this.isCachedHashValue = false;
    }

    public synchronized IOR getTargetIOR() {
        return this.targetIOR;
    }

    public synchronized void setEffectiveTargetIOR(IOR effectiveTargetIOR) {
        this.effectiveTargetIOR = effectiveTargetIOR;
        this.effectiveTargetIORContactInfoList = null;
        if (this.primaryContactInfo != null && this.orb.getORBData().getIIOPPrimaryToContactInfo() != null) {
            this.orb.getORBData().getIIOPPrimaryToContactInfo().reset(this.primaryContactInfo);
        }
        this.primaryContactInfo = null;
        this.setLocalSubcontract();
    }

    public synchronized IOR getEffectiveTargetIOR() {
        return this.effectiveTargetIOR;
    }

    public synchronized LocalClientRequestDispatcher getLocalClientRequestDispatcher() {
        return this.LocalClientRequestDispatcher;
    }

    public synchronized int hashCode() {
        if (!this.isCachedHashValue) {
            this.cachedHashValue = this.targetIOR.stringify().hashCode();
            this.isCachedHashValue = true;
        }
        return this.cachedHashValue;
    }

    protected void createContactInfoList() {
        IIOPProfile iiopProfile = this.effectiveTargetIOR.getProfile();
        if (this.effectiveTargetIORContactInfoList == null) {
            this.effectiveTargetIORContactInfoList = new ArrayList();
            String hostname = ((IIOPProfileTemplate)iiopProfile.getTaggedProfileTemplate()).getPrimaryAddress().getHost().toLowerCase();
            int port = ((IIOPProfileTemplate)iiopProfile.getTaggedProfileTemplate()).getPrimaryAddress().getPort();
            this.primaryContactInfo = this.createContactInfo("IIOP_CLEAR_TEXT", hostname, port);
            if (iiopProfile.isLocal()) {
                SharedCDRContactInfoImpl contactInfo = new SharedCDRContactInfoImpl(this.orb, this, this.effectiveTargetIOR, this.orb.getORBData().getGIOPAddressDisposition());
                this.effectiveTargetIORContactInfoList.add(contactInfo);
            } else {
                this.addRemoteContactInfos(this.effectiveTargetIOR, this.effectiveTargetIORContactInfoList);
            }
            if (this.orb.transportDebugFlag) {
                this.dprint(".createContactInfoList: first time for: " + iiopProfile + " list: " + this.effectiveTargetIORContactInfoList);
            }
        } else if (!iiopProfile.isLocal()) {
            this.addRemoteContactInfos(this.effectiveTargetIOR, this.effectiveTargetIORContactInfoList);
        } else if (this.orb.transportDebugFlag) {
            this.dprint(".createContactInfoList: subsequent for: " + iiopProfile + " colocated so no change");
        }
    }

    protected void addRemoteContactInfos(IOR effectiveTargetIOR, List effectiveTargetIORContactInfoList) {
        List socketInfos = this.orb.getORBData().getIORToSocketInfo().getSocketInfo(effectiveTargetIOR, effectiveTargetIORContactInfoList);
        if (socketInfos == effectiveTargetIORContactInfoList) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".addRemoteContactInfos: no change: " + socketInfos);
            }
            return;
        }
        for (SocketInfo socketInfo : socketInfos) {
            String type = socketInfo.getType();
            String host = socketInfo.getHost().toLowerCase();
            int port = socketInfo.getPort();
            ContactInfo contactInfo = this.createContactInfo(type, host, port);
            effectiveTargetIORContactInfoList.add(contactInfo);
        }
    }

    protected ContactInfo createContactInfo(String type, String hostname, int port) {
        return new SocketOrChannelContactInfoImpl(this.orb, this, this.effectiveTargetIOR, this.orb.getORBData().getGIOPAddressDisposition(), type, hostname, port);
    }

    protected void setLocalSubcontract() {
        if (!this.effectiveTargetIOR.getProfile().isLocal()) {
            this.LocalClientRequestDispatcher = new NotLocalLocalCRDImpl();
            return;
        }
        int scid = this.effectiveTargetIOR.getProfile().getObjectKeyTemplate().getSubcontractId();
        LocalClientRequestDispatcherFactory lcsf = this.orb.getRequestDispatcherRegistry().getLocalClientRequestDispatcherFactory(scid);
        this.LocalClientRequestDispatcher = lcsf.create(scid, this.effectiveTargetIOR);
    }

    public ContactInfo getPrimaryContactInfo() {
        return this.primaryContactInfo;
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaContactInfoListImpl", msg);
    }
}

