/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.copyobject.newreflect;

import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopier;
import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopierBase;
import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopierFactory;
import com.sun.corba.ee.spi.copyobject.ReflectiveCopyException;
import java.util.Map;

public abstract class DefaultClassCopiers {
    private static ClassCopier identityClassCopier = new ClassCopierBase("identity"){

        public Object createCopy(Object source) throws ReflectiveCopyException {
            return source;
        }

        public Object createCopy(Object source, boolean debug) throws ReflectiveCopyException {
            return source;
        }
    };
    private static ClassCopier errorClassCopier = new ClassCopierBase("error", true){

        public Object createCopy(Object source) throws ReflectiveCopyException {
            return this.createCopy(source, false);
        }

        public Object createCopy(Object source, boolean debug) throws ReflectiveCopyException {
            throw new ReflectiveCopyException("Cannot copy class " + source.getClass());
        }
    };

    private DefaultClassCopiers() {
    }

    public static ClassCopier getIdentityClassCopier() {
        return identityClassCopier;
    }

    public static ClassCopier getErrorClassCopier() {
        return errorClassCopier;
    }

    public static ClassCopier makeMapClassCopier(final ClassCopierFactory ccf) {
        return new ClassCopierBase("map"){

            public Object createCopy(Object source, boolean debug) throws ReflectiveCopyException {
                try {
                    return source.getClass().newInstance();
                }
                catch (Exception exc) {
                    throw new ReflectiveCopyException("MapCopier could not copy " + source.getClass(), exc);
                }
            }

            private Object myCopy(Map oldToNew, Object obj) throws ReflectiveCopyException {
                if (obj == null) {
                    return null;
                }
                Class<?> cls = obj.getClass();
                ClassCopier copier = ccf.getClassCopier(cls);
                return copier.copy(oldToNew, obj);
            }

            public Object doCopy(Map oldToNew, Object source, Object result, boolean debug) throws ReflectiveCopyException {
                Map sourceMap = (Map)source;
                Map resultMap = (Map)result;
                for (Map.Entry entry : sourceMap.entrySet()) {
                    Object key = entry.getKey();
                    Object newKey = this.myCopy(oldToNew, key);
                    Object value = entry.getValue();
                    Object newValue = this.myCopy(oldToNew, value);
                    resultMap.put(newKey, newValue);
                }
                return result;
            }
        };
    }
}

