/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.codegen;

import com.sun.corba.ee.impl.codegen.BlockStatement;
import com.sun.corba.ee.impl.codegen.ClassGenerator;
import com.sun.corba.ee.impl.codegen.ClassInfo;
import com.sun.corba.ee.impl.codegen.Field;
import com.sun.corba.ee.impl.codegen.Node;
import com.sun.corba.ee.impl.codegen.NodeBase;
import com.sun.corba.ee.impl.codegen.Visitor;
import com.sun.corba.ee.spi.codegen.Expression;
import com.sun.corba.ee.spi.codegen.Signature;
import com.sun.corba.ee.spi.codegen.Type;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExpressionFactory {
    private final Node efparent;

    ExpressionFactory(Node parent) {
        this.efparent = parent;
    }

    public Expression _null() {
        return new ConstantExpression(this.efparent, Type._null(), null);
    }

    public Expression _const(boolean c) {
        return new ConstantExpression(this.efparent, Type._boolean(), c);
    }

    public Expression _const(char c) {
        return new ConstantExpression(this.efparent, Type._char(), Character.valueOf(c));
    }

    public Expression _const(byte c) {
        return new ConstantExpression(this.efparent, Type._byte(), c);
    }

    public Expression _const(short c) {
        return new ConstantExpression(this.efparent, Type._short(), c);
    }

    public Expression _const(int c) {
        return new ConstantExpression(this.efparent, Type._int(), c);
    }

    public Expression _const(long c) {
        return new ConstantExpression(this.efparent, Type._long(), c);
    }

    public Expression _const(float c) {
        return new ConstantExpression(this.efparent, Type._float(), Float.valueOf(c));
    }

    public Expression _const(double c) {
        return new ConstantExpression(this.efparent, Type._double(), c);
    }

    public Expression _const(String c) {
        return new ConstantExpression(this.efparent, Type._String(), c);
    }

    public Expression _const(Type c) {
        return new ConstantExpression(this.efparent, Type._Class(), c);
    }

    public Expression _void() {
        return new VoidExpression(this.efparent);
    }

    public Expression _this() {
        return new ThisExpression(this.efparent);
    }

    public Expression call(Expression target, String ident, Signature signature, List<Expression> args) {
        return new NonStaticCallExpression(this.efparent, target, ident, signature, args);
    }

    public Expression call(Expression target, String ident, List<Expression> exprs) {
        Signature sig = Signature.fromCall(target.type(), ident, exprs);
        return new NonStaticCallExpression(this.efparent, target, ident, sig, exprs);
    }

    public Expression staticCall(Type target, String ident, Signature signature, List<Expression> exprs) {
        if (target.isPrimitive() || target.isArray()) {
            throw new IllegalArgumentException("The target for a static call must be a reference type");
        }
        return new StaticCallExpression(this.efparent, target, ident, signature, exprs);
    }

    public Expression staticCall(Type target, String ident, List<Expression> exprs) {
        if (target.isPrimitive() || target.isArray()) {
            throw new IllegalArgumentException("The target for a static call must be a reference type");
        }
        Signature sig = Signature.fromStaticCall(target, ident, exprs);
        return new StaticCallExpression(this.efparent, target, ident, sig, exprs);
    }

    public Expression unaryOp(UnaryOperator op, Expression expr) {
        return new UnaryOperatorExpression(this.efparent, op, expr);
    }

    public Expression binaryOperator(Expression left, BinaryOperator op, Expression right) {
        return new BinaryOperatorExpression(this.efparent, left, op, right);
    }

    public Expression cast(Type type, Expression expr) {
        return new CastExpression(this.efparent, type, expr);
    }

    public Expression instof(Expression expr, Type type) {
        return new InstofExpression(this.efparent, expr, type);
    }

    public Expression newObj(Type type, Signature signature, List<Expression> args) {
        return new NewObjExpression(this.efparent, type, signature, args);
    }

    public Expression newObj(Type type, List<Expression> exprs) {
        Signature signature = Signature.fromConstructor(type, exprs);
        return new NewObjExpression(this.efparent, type, signature, exprs);
    }

    public Expression newArrInit(Type type, List<Expression> exprs) {
        Expression size = this._const(exprs.size());
        return new NewArrExpression(this.efparent, type, size, exprs);
    }

    public Expression newArr(Type type, Expression size) {
        return new NewArrExpression(this.efparent, type, size, null);
    }

    public Expression superCall(String ident, Signature signature, List<Expression> exprs) {
        return new SuperCallExpression(this.efparent, ident, signature, exprs);
    }

    private ClassGenerator getContainingClass() {
        Node current;
        for (current = this.efparent; current != null && !(current instanceof ClassGenerator); current = current.parent()) {
        }
        if (current == null) {
            throw new IllegalStateException("No ClassGenerator found!");
        }
        return (ClassGenerator)ClassGenerator.class.cast(current);
    }

    public Expression superCall(String ident, List<Expression> exprs) {
        Type type = this.getContainingClass().superType();
        Signature signature = Signature.fromCall(type, ident, exprs);
        return new SuperCallExpression(this.efparent, ident, signature, exprs);
    }

    public Expression superObj(Signature signature, List<Expression> exprs) {
        return new SuperObjExpression(this.efparent, signature, exprs);
    }

    public Expression superObj(List<Expression> exprs) {
        Type type = this.getContainingClass().superType();
        Signature signature = Signature.fromConstructor(type, exprs);
        return new SuperObjExpression(this.efparent, signature, exprs);
    }

    public Expression thisObj(Signature signature, List<Expression> exprs) {
        return new ThisObjExpression(this.efparent, signature, exprs);
    }

    public Expression thisObj(List<Expression> exprs) {
        Type type = Type._class(this.getContainingClass().name());
        Signature signature = Signature.fromConstructor(type, exprs);
        return new ThisObjExpression(this.efparent, signature, exprs);
    }

    public Expression fieldAccess(Expression target, String fieldName) {
        return new NonStaticFieldAccessExpression(this.efparent, target, fieldName);
    }

    public Expression fieldAccess(Type target, String fieldName) {
        return new StaticFieldAccessExpression(this.efparent, target, fieldName);
    }

    public Expression arrayIndex(Expression expr, Expression index) {
        return new ArrayIndexExpression(this.efparent, expr, index);
    }

    public static class ArrayIndexExpression
    extends ExpressionBase {
        private Expression expr;
        private Expression index;

        public boolean isAssignable() {
            return true;
        }

        public Expression expr() {
            return this.expr;
        }

        public Expression index() {
            return this.index;
        }

        ArrayIndexExpression(Node parent, Expression expr, Expression index) {
            super(parent);
            this.expr = BlockStatement.splitVariables(parent, expr);
            this.index = BlockStatement.splitVariables(parent, index);
        }

        public Type type() {
            return Type._boolean();
        }

        public void accept(Visitor visitor) {
            visitor.visitArrayIndexExpression(this);
        }

        public String toString() {
            return "ArrayIndexExpression[]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StaticFieldAccessExpression
    extends FieldAccessExpressionBase<Type> {
        public StaticFieldAccessExpression(Node parent, Type target, String fieldName) {
            super(parent, target, fieldName);
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        @Override
        public Type targetType() {
            return (Type)this.target();
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitStaticFieldAccessExpression(this);
        }

        public String toString() {
            return "StaticFieldAccessExpression[" + ((Type)this.target()).name() + " " + this.fieldName() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NonStaticFieldAccessExpression
    extends FieldAccessExpressionBase<Expression> {
        public NonStaticFieldAccessExpression(Node parent, Expression target, String fieldName) {
            super(parent, BlockStatement.splitVariables(parent, target), fieldName);
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public Type targetType() {
            return ((Expression)this.target()).type();
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitNonStaticFieldAccessExpression(this);
        }

        public String toString() {
            return "NonStaticFieldAccessExpression[" + this.fieldName() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class FieldAccessExpressionBase<T>
    extends ExpressionBase {
        private T target;
        private String fieldName;

        @Override
        public boolean isAssignable() {
            return true;
        }

        abstract boolean isStatic();

        abstract Type targetType();

        public T target() {
            return this.target;
        }

        public String fieldName() {
            return this.fieldName;
        }

        FieldAccessExpressionBase(Node parent, T target, String fieldName) {
            super(parent);
            this.target = target;
            this.fieldName = fieldName;
        }

        @Override
        public Type type() {
            ClassInfo cinfo;
            try {
                cinfo = this.targetType().classInfo();
            }
            catch (ClassNotFoundException exc) {
                throw new IllegalStateException(exc);
            }
            Field fld = cinfo.fields().get(this.fieldName);
            if (fld == null) {
                throw new IllegalStateException("Type " + this.targetType().name() + " does not contain field " + this.fieldName);
            }
            return fld.type();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ThisObjExpression
    extends ExpressionBase {
        private Signature signature;
        private List<Expression> exprs;

        public Signature signature() {
            return this.signature;
        }

        public List<Expression> exprs() {
            return this.exprs;
        }

        public ThisObjExpression(Node parent, Signature signature, List<Expression> exprs) {
            super(parent);
            this.signature = signature;
            this.exprs = BlockStatement.splitVariables(parent, exprs);
        }

        @Override
        public Type type() {
            return Type._void();
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitThisObjExpression(this);
        }

        public String toString() {
            return "ThisObjExpression[" + this.signature + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SuperObjExpression
    extends ExpressionBase {
        private Signature signature;
        private List<Expression> exprs;

        public Signature signature() {
            return this.signature;
        }

        public List<Expression> exprs() {
            return this.exprs;
        }

        public SuperObjExpression(Node parent, Signature signature, List<Expression> exprs) {
            super(parent);
            this.signature = signature;
            this.exprs = BlockStatement.splitVariables(parent, exprs);
        }

        @Override
        public Type type() {
            return Type._void();
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitSuperObjExpression(this);
        }

        public String toString() {
            return "SuperObjExpression[" + this.signature + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SuperCallExpression
    extends ExpressionBase {
        private String ident;
        private Signature signature;
        private List<Expression> exprs;

        public String ident() {
            return this.ident;
        }

        public Signature signature() {
            return this.signature;
        }

        public List<Expression> exprs() {
            return this.exprs;
        }

        public SuperCallExpression(Node parent, String ident, Signature signature, List<Expression> exprs) {
            super(parent);
            this.ident = ident;
            this.signature = signature;
            this.exprs = BlockStatement.splitVariables(parent, exprs);
        }

        @Override
        public Type type() {
            return this.signature.returnType();
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitSuperCallExpression(this);
        }

        public String toString() {
            return "SuperCallExpression[" + this.ident + " " + this.signature + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NewArrExpression
    extends ExpressionBase {
        private Type ctype;
        private Expression size;
        private List<Expression> exprs;

        public Type ctype() {
            return this.ctype;
        }

        public Expression size() {
            return this.size;
        }

        public List<Expression> exprs() {
            return this.exprs;
        }

        NewArrExpression(Node parent, Type ctype, Expression size, List<Expression> exprs) {
            super(parent);
            this.ctype = ctype;
            this.size = size;
            this.exprs = exprs;
        }

        @Override
        public Type type() {
            return Type._array(this.ctype);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitNewArrExpression(this);
        }

        public String toString() {
            return "NewArrExpression[" + this.ctype.name() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NewObjExpression
    extends ExpressionBase {
        private Type type;
        private Signature signature;
        private List<Expression> args;

        public final Signature signature() {
            return this.signature;
        }

        public final List<Expression> args() {
            return this.args;
        }

        NewObjExpression(Node parent, Type type, Signature signature, List<Expression> args) {
            super(parent);
            this.type = type;
            this.signature = signature;
            if (!signature.returnType().equals(Type._void())) {
                throw new IllegalArgumentException("The signature of a new call to a constructor must have a void return type");
            }
            this.args = BlockStatement.splitVariables(parent, args);
        }

        @Override
        public Type type() {
            return this.type;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitNewObjExpression(this);
        }

        public String toString() {
            return "NewObjExpression[" + this.type.name() + " " + this.signature + "]";
        }
    }

    public static class InstofExpression
    extends ExpressionBase {
        private Expression expr;
        private Type itype;

        public Expression expr() {
            return this.expr;
        }

        public Type itype() {
            return this.itype;
        }

        InstofExpression(Node parent, Expression expr, Type type) {
            super(parent);
            this.expr = BlockStatement.splitVariables(parent, expr);
            this.itype = type;
        }

        public Type type() {
            return Type._boolean();
        }

        public void accept(Visitor visitor) {
            visitor.visitInstofExpression(this);
        }

        public String toString() {
            return "InstofExpression[" + this.itype.name() + "]";
        }
    }

    public static class CastExpression
    extends ExpressionBase {
        private Type type;
        private Expression expr;

        public Type type() {
            return this.type;
        }

        public Expression expr() {
            return this.expr;
        }

        CastExpression(Node parent, Type type, Expression expr) {
            super(parent);
            this.type = type;
            this.expr = BlockStatement.splitVariables(parent, expr);
        }

        public void accept(Visitor visitor) {
            visitor.visitCastExpression(this);
        }

        public String toString() {
            return "CastExpression[" + this.type.name() + "]";
        }
    }

    public static class BinaryOperatorExpression
    extends ExpressionBase {
        private Expression left;
        private BinaryOperator op;
        private Expression right;

        public BinaryOperator operator() {
            return this.op;
        }

        public Expression left() {
            return this.left;
        }

        public Expression right() {
            return this.right;
        }

        BinaryOperatorExpression(Node parent, Expression left, BinaryOperator op, Expression right) {
            super(parent);
            this.left = BlockStatement.splitVariables(parent, left);
            this.op = op;
            this.right = BlockStatement.splitVariables(parent, right);
        }

        public Type type() {
            return Type._boolean();
        }

        public void accept(Visitor visitor) {
            visitor.visitBinaryOperatorExpression(this);
        }

        public String toString() {
            return "BinaryOperatorExpression[" + (Object)((Object)this.op) + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BinaryOperator {
        GT(">"){

            public void checkTypes(Expression left, Expression right) {
                this.checkNumberTypes(left.type(), right.type());
            }
        }
        ,
        GE(">="){

            public void checkTypes(Expression left, Expression right) {
                this.checkNumberTypes(left.type(), right.type());
            }
        }
        ,
        LT("<"){

            public void checkTypes(Expression left, Expression right) {
                this.checkNumberTypes(left.type(), right.type());
            }
        }
        ,
        LE("<="){

            public void checkTypes(Expression left, Expression right) {
                this.checkNumberTypes(left.type(), right.type());
            }
        }
        ,
        EQ("=="){

            public void checkTypes(Expression left, Expression right) {
                this.checkEQOPTypes(left.type(), right.type());
            }
        }
        ,
        NE("!="){

            public void checkTypes(Expression left, Expression right) {
                this.checkEQOPTypes(left.type(), right.type());
            }
        }
        ,
        AND("&&"){

            public void checkTypes(Expression left, Expression right) {
                if (left != Type._boolean() || right != Type._boolean()) {
                    throw new IllegalArgumentException(this.javaRepresentation() + " requires boolean expressions");
                }
            }
        }
        ,
        OR("||"){

            public void checkTypes(Expression left, Expression right) {
                if (left != Type._boolean() || right != Type._boolean()) {
                    throw new IllegalArgumentException(this.javaRepresentation() + " requires boolean expressions");
                }
            }
        };

        private final String javaRepresentation;

        void checkEQOPTypes(Type left, Type right) {
            if (left == Type._null() && right.isPrimitive()) {
                throw new IllegalArgumentException("Comparisons with null require reference types for operator " + this.javaRepresentation());
            }
            if (right == Type._null() && left.isPrimitive()) {
                throw new IllegalArgumentException("Comparisons with null require reference types for operator " + this.javaRepresentation());
            }
            this.checkEqualTypes(left, right);
        }

        private void checkEqualTypes(Type left, Type right) {
            if (left != right) {
                throw new IllegalArgumentException(this.javaRepresentation + " requires both types to be the same (no automatic conversions)");
            }
        }

        void checkNumberTypes(Type left, Type right) {
            this.checkEqualTypes(left, right);
            if (!left.isNumber()) {
                throw new IllegalArgumentException(this.javaRepresentation + " requires both expressions to be numbers");
            }
        }

        public String javaRepresentation() {
            return this.javaRepresentation;
        }

        public abstract void checkTypes(Expression var1, Expression var2);

        private BinaryOperator(String javaRepresentation) {
            this.javaRepresentation = javaRepresentation;
        }
    }

    public static class UnaryOperatorExpression
    extends ExpressionBase {
        private UnaryOperator op;
        private Expression expr;

        public UnaryOperator operator() {
            return this.op;
        }

        public Expression expr() {
            return this.expr;
        }

        public Type type() {
            return Type._boolean();
        }

        UnaryOperatorExpression(Node parent, UnaryOperator op, Expression expr) {
            super(parent);
            this.op = op;
            this.expr = BlockStatement.splitVariables(parent, expr);
        }

        public void accept(Visitor visitor) {
            visitor.visitUnaryOperatorExpression(this);
        }

        public String toString() {
            return "UnaryOperatorExpression[" + (Object)((Object)this.op) + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnaryOperator {
        NOT("!"){

            public void checkType(Expression arg) {
                if (arg.type() != Type._boolean()) {
                    throw new IllegalArgumentException("! expects a boolean type, found " + arg.type());
                }
            }
        };

        private final String javaRepresentation;

        public String javaRepresentation() {
            return this.javaRepresentation;
        }

        public abstract void checkType(Expression var1);

        private UnaryOperator(String javaRepresentation) {
            this.javaRepresentation = javaRepresentation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NonStaticCallExpression
    extends CallExpression<Expression> {
        NonStaticCallExpression(Node parent, Expression target, String ident, Signature signature, List<Expression> args) {
            super(parent, BlockStatement.splitVariables(parent, target), ident, signature, args);
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public final void accept(Visitor visitor) {
            visitor.visitNonStaticCallExpression(this);
        }

        public String toString() {
            return "NonStaticCallExpression[ident=" + this.ident() + " " + "signature=" + this.signature() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StaticCallExpression
    extends CallExpression<Type> {
        StaticCallExpression(Node parent, Type target, String ident, Signature signature, List<Expression> args) {
            super(parent, target, ident, signature, args);
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        @Override
        public final void accept(Visitor visitor) {
            visitor.visitStaticCallExpression(this);
        }

        public String toString() {
            return "StaticCallExpression[target=" + this.target() + " " + "ident=" + this.ident() + " " + "signature=" + this.signature() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CallExpression<T>
    extends ExpressionBase {
        private T target;
        private String ident;
        private Signature signature;
        private List<Expression> args;

        public abstract boolean isStatic();

        CallExpression(Node parent, T target, String ident, Signature signature, List<Expression> args) {
            super(parent);
            this.target = target;
            this.ident = ident;
            this.signature = signature;
            this.args = BlockStatement.splitVariables(parent, args);
        }

        public final T target() {
            return this.target;
        }

        public final String ident() {
            return this.ident;
        }

        public final Signature signature() {
            return this.signature;
        }

        public final List<Expression> args() {
            return this.args;
        }

        @Override
        public final Type type() {
            return this.signature.returnType();
        }

        @Override
        public abstract void accept(Visitor var1);
    }

    public static class ThisExpression
    extends ExpressionBase {
        public ThisExpression(Node parent) {
            super(parent);
        }

        public Type type() {
            Node current;
            for (current = this; current != null && !(current instanceof ClassGenerator); current = current.parent()) {
            }
            if (current == null) {
                throw new RuntimeException("Internal error: no ClassGenerator found that contains expression");
            }
            ClassGenerator cg = (ClassGenerator)ClassGenerator.class.cast(current);
            Type cgType = Type._classGenerator(cg);
            return cgType;
        }

        public void accept(Visitor visitor) {
            visitor.visitThisExpression(this);
        }

        public String toString() {
            return "ThisExpression[]";
        }
    }

    public static class VoidExpression
    extends ExpressionBase {
        VoidExpression(Node parent) {
            super(parent);
        }

        public Type type() {
            return Type._void();
        }

        public void accept(Visitor visitor) {
            visitor.visitVoidExpression(this);
        }

        public String toString() {
            return "VoidExpression[]";
        }
    }

    public static class ConstantExpression
    extends ExpressionBase {
        private Type type;
        private Object value;

        ConstantExpression(Node parent, Type type, Object value) {
            super(parent);
            this.type = type;
            this.value = value;
        }

        public String toString() {
            String valueStr = this.value == null ? "null" : this.value.toString();
            return "ConstantExpression[" + this.type + ":" + valueStr + "]";
        }

        public Type type() {
            return this.type;
        }

        public Object value() {
            return this.value;
        }

        public void accept(Visitor visitor) {
            visitor.visitConstantExpression(this);
        }
    }

    public static abstract class ExpressionBase
    extends NodeBase
    implements Expression {
        public ExpressionBase(Node parent) {
            super(parent);
        }

        public boolean isAssignable() {
            return false;
        }
    }
}

