/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.certconversion;

import com.sun.enterprise.tools.upgrade.certconversion.CertificateException;
import com.sun.enterprise.tools.upgrade.certconversion.ProcessAdaptor;
import com.sun.enterprise.tools.upgrade.common.BaseModule;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.UpdateProgressManager;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JKStoNSSConversionModule
implements BaseModule {
    private static Logger _logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
    private StringManager sm = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.certconversion");
    private static final String PKCS12_INPUTFILE_OPTION = "-i";
    private static final String NSS_DB_LOCATION_OPTION = "-d";
    private static final String NSS_PWD_OPTION = "-K";
    private static final String KEYSTORE_PWD_OPTION = "-W";
    private static final String PK12_UTIL_UNIX = "pk12util.sh";
    private static final String PK12_UTIL_WIN = "pk12util.bat";
    private static final String CONFIG = "config";
    private static final String BIN = "bin";
    private static final String LIB = "lib";
    String pathOfNSSDbFiles;
    private String jksPath;
    private String trustJksPath;
    private List pkcs12PathList;
    private String nssKeyStorePassword;
    private List keyList;
    private InputStream isJksPath;
    private OutputStream osJksPath;
    private OutputStream trustJKSPathStream;
    private String jksKeyStorePassword;
    private String jksCAkeyStorePassword;
    private boolean certificateError = false;
    private char[] pwd;
    private KeyStore trustedJksKeyStore;
    private CommonInfoModel commonInfo;
    private String pkcs12FilePath;
    private OutputStream pkcs12KeystoreStream;
    private KeyStore jksKeyStore;
    private KeyStore pkcs12KeyStore;

    public void recovery(CommonInfoModel commonInfo) {
    }

    public boolean upgrade(CommonInfoModel commonInfo) {
        String currentDomain = commonInfo.getCurrentDomain();
        if (!commonInfo.getDomainOptionList().contains(currentDomain)) {
            return true;
        }
        this.pkcs12FilePath = commonInfo.getDestinationDomainPath() + File.separator + "pkcsFile" + ".pkcs12";
        this.jksPath = commonInfo.getSourceJKSKeyStorePath();
        this.trustJksPath = commonInfo.getSourceTrustedJKSKeyStorePath();
        this.jksKeyStorePassword = commonInfo.getJksKeystorePassword();
        this.jksCAkeyStorePassword = commonInfo.getJksCAKeystorePassword();
        this.pkcs12PathList = new ArrayList();
        this.keyList = new ArrayList();
        this.nssKeyStorePassword = commonInfo.getCertDbPassword();
        this.commonInfo = commonInfo;
        try {
            this.runPkcs12ToJks();
        }
        catch (CertificateException ce) {
            _logger.log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.certconversion.could_not_migrate_certificates", (Object)ce));
            UpdateProgressManager.getProgressManager().setContinueUpgrade(false);
            return false;
        }
        return true;
    }

    private void runPkcs12ToJks() throws CertificateException {
        this.openInputKeystoreJKS();
        this.openOutputKeystore();
        this.convertjksTopkcs12();
        this.storepkcs12KeyStore();
        this.migratepkcs12TonssDB();
    }

    private void migratepkcs12TonssDB() throws CertificateException {
        String targetDomainDir = this.commonInfo.getDestinationDomainPath();
        String configDir = targetDomainDir + File.separator + CONFIG;
        String targetLib = this.commonInfo.getTargetInstallDir() + File.separator + LIB;
        String targetBin = this.commonInfo.getTargetInstallDir() + File.separator + BIN;
        String pk12UtilPath = "";
        String osName = this.commonInfo.getOSName();
        pk12UtilPath = osName.indexOf("Windows") == -1 ? this.commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + PK12_UTIL_UNIX : this.commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + PK12_UTIL_WIN;
        String pk12utilLocation = this.commonInfo.getTargetInstallDir() + File.separator + LIB;
        String[] commandArray = new String[]{pk12UtilPath, targetLib, targetBin, pk12utilLocation, PKCS12_INPUTFILE_OPTION, this.pkcs12FilePath, NSS_DB_LOCATION_OPTION, configDir, NSS_PWD_OPTION, this.commonInfo.getCertDbPassword(), KEYSTORE_PWD_OPTION, this.commonInfo.getJksKeystorePassword()};
        StringWriter result = new StringWriter();
        int exitVal = ProcessAdaptor.executeProcess(commandArray, (Writer)result);
        result.flush();
        if (exitVal == 0) {
            Iterator itr = this.keyList.iterator();
            while (itr.hasNext()) {
                _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.alias_transferred", (Object)((String)itr.next())));
            }
        } else {
            _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.certificateError", (Object)this.pkcs12FilePath, (Object)this.commonInfo.getCurrentDomain(), (Object)result.toString()));
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.certconversion.certificateError", (Object)this.pkcs12FilePath, (Object)this.commonInfo.getCurrentDomain(), (Object)result.toString()));
        }
    }

    private void storepkcs12KeyStore() throws CertificateException {
        try {
            this.pkcs12KeystoreStream = new FileOutputStream(this.pkcs12FilePath);
            this.pkcs12KeyStore.store(this.pkcs12KeystoreStream, this.jksKeyStorePassword.toCharArray());
            Enumeration<String> aliases = this.pkcs12KeyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                System.out.println("Added keystore alias: " + alias);
                _logger.log(Level.INFO, "Added keystore alias: " + alias);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.certconversion.certificate_JKS_Error"), ex);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.certconversion.certificate_JKS_Error"));
        }
        finally {
            if (this.pkcs12KeystoreStream != null) {
                try {
                    this.pkcs12KeystoreStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void openInputKeystoreJKS() throws CertificateException {
        FileInputStream inputStreamJks = null;
        try {
            inputStreamJks = new FileInputStream(this.jksPath);
            this.jksKeyStore = KeyStore.getInstance("JKS");
            this.jksKeyStore.load(inputStreamJks, this.jksKeyStorePassword.toCharArray());
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.certconversion.JKS_Password_Error"), e);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.certconversion.JKS_Password_Error"));
        }
        finally {
            if (inputStreamJks != null) {
                try {
                    ((InputStream)inputStreamJks).close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void openOutputKeystore() throws CertificateException {
        try {
            this.pkcs12KeyStore = KeyStore.getInstance("PKCS12");
            this.pkcs12KeyStore.load(null, this.jksKeyStorePassword.toCharArray());
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.certconversion.JKS_Password_Error"), e);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.certconversion.JKS_Password_Error"));
        }
    }

    public void writeToOutputKeystore(Key key, Certificate[] cert, String alias) throws CertificateException {
        try {
            this.pkcs12KeyStore.setKeyEntry(alias, key, this.jksKeyStorePassword.toCharArray(), cert);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.certconversion.JKS_Password_Error"), e);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.certconversion.JKS_Password_Error"));
        }
    }

    public void writeToOutputTrustedKeystore(Certificate cert, String alias) throws CertificateException {
        try {
            this.pkcs12KeyStore.setCertificateEntry(alias, cert);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.certconversion.JKS_Password_Error"), e);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.certconversion.JKS_Password_Error"));
        }
    }

    public void convertjksTopkcs12() throws CertificateException {
        try {
            Enumeration<String> en = this.jksKeyStore.aliases();
            int i = 0;
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.processing_keypair", (Object)alias));
                Key key = this.jksKeyStore.getKey(alias, this.jksKeyStorePassword.toCharArray());
                this.keyList.add(alias);
                Certificate[] cert = this.jksKeyStore.getCertificateChain(alias);
                this.writeToOutputKeystore(key, cert, alias);
                ++i;
            }
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.certconversion.processing_keypair", (Object)e));
            throw new CertificateException(e.getMessage());
        }
    }

    private void deletePKCS12Files() {
        new File(this.pkcs12FilePath).delete();
    }

    public static void main(String[] args) {
        JKStoNSSConversionModule convModule = new JKStoNSSConversionModule();
    }

    public String getName() {
        return this.sm.getString("enterprise.tools.upgrade.certconversion.moduleName");
    }
}

