/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component.util.factories;

import com.sun.web.ui.component.util.descriptors.LayoutComponent;
import com.sun.web.ui.component.util.factories.ComponentFactory;
import com.sun.web.ui.util.LogUtil;
import com.sun.web.ui.util.VariableResolver;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentTag;

public abstract class ComponentFactoryBase
implements ComponentFactory {
    protected void setOptions(FacesContext context, LayoutComponent desc, UIComponent comp) {
        String compId = desc.getId(context, comp.getParent());
        if (compId != null && !compId.equals("")) {
            comp.setId(compId);
        }
        Map attributes = comp.getAttributes();
        Iterator it = desc.getOptions().keySet().iterator();
        Object value = null;
        String strVal = null;
        String key = null;
        while (it.hasNext()) {
            key = (String)it.next();
            value = desc.getEvaluatedOption(context, key, comp);
            strVal = "" + value;
            if (UIComponentTag.isValueReference((String)strVal)) {
                ValueBinding vb = context.getApplication().createValueBinding(strVal);
                comp.setValueBinding(key, vb);
                continue;
            }
            try {
                attributes.put(key, value);
            }
            catch (NullPointerException ex) {
                attributes.remove(key);
            }
        }
        this.storeInstanceHandlers(desc, comp);
    }

    protected void storeInstanceHandlers(LayoutComponent desc, UIComponent comp) {
        Iterator it = desc.getHandlersByTypeMap().keySet().iterator();
        if (it.hasNext()) {
            String eventType = null;
            Map compAttrs = comp.getAttributes();
            while (it.hasNext()) {
                eventType = (String)it.next();
                compAttrs.put(eventType, desc.getHandlers(eventType));
            }
        }
    }

    protected void addChild(FacesContext context, LayoutComponent descriptor, UIComponent parent, UIComponent child) {
        if (descriptor.isFacetChild()) {
            String name = (String)descriptor.getEvaluatedOption(context, "_facetName", child);
            if (name != null) {
                parent.getFacets().put(name, child);
            } else {
                if (LogUtil.configEnabled()) {
                    LogUtil.config("Warning: no facet name was supplied for '" + descriptor.getId(context, child) + "'!");
                }
                child.setParent(parent);
            }
        } else {
            parent.getChildren().add(child);
        }
    }

    protected Object getEvaluatedOption(FacesContext context, LayoutComponent desc, UIComponent parent, String key, boolean required) {
        Object[] val = desc.getOption(key);
        if (val != null) {
            if (val instanceof List) {
                Object[] args = ((List)val).toArray();
                for (int count = 0; count < args.length; ++count) {
                    args[count] = VariableResolver.resolveVariables(context, desc, parent, (String)args[count]);
                }
                val = args;
            } else {
                val = VariableResolver.resolveVariables(context, desc, parent, val);
            }
        }
        if (required && val == null) {
            throw new IllegalArgumentException("'" + key + "' is required!");
        }
        return val;
    }
}

