/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.objstore;

import com.sun.messaging.jmq.admin.objstore.NameAlreadyExistsException;
import com.sun.messaging.jmq.admin.objstore.NameNotFoundException;
import com.sun.messaging.jmq.admin.objstore.ObjStore;
import com.sun.messaging.jmq.admin.objstore.ObjStoreAttrs;
import com.sun.messaging.jmq.admin.objstore.ObjStoreException;
import com.sun.messaging.jmq.admin.objstore.ObjStoreTypeNotSupportedException;
import com.sun.messaging.jmq.admin.objstore.jndi.JNDIStore;
import java.util.Vector;

public class ObjStoreManager {
    private boolean DEBUG = false;
    private static ObjStoreManager mgr = null;
    public static final int JNDI = 0;
    protected Vector objStores = new Vector();

    protected ObjStoreManager() {
    }

    public static synchronized ObjStoreManager getObjStoreManager() {
        if (mgr == null) {
            mgr = new ObjStoreManager();
        }
        return mgr;
    }

    public ObjStore createStore(ObjStoreAttrs objStoreAttrs) throws ObjStoreException {
        String string = objStoreAttrs.getID();
        if (this.DEBUG) {
            System.out.println("DEBUG: ObjStoreManager.createStore() getID() ---> " + string);
        }
        if (!this.idExists(string)) {
            ObjStore objStore = ObjStoreFactory.createStore(objStoreAttrs);
            this.objStores.addElement(objStore);
            return objStore;
        }
        throw new NameAlreadyExistsException();
    }

    public void destroyStore(String string) throws ObjStoreException {
        if (!this.idExists(string)) {
            throw new NameNotFoundException();
        }
        this.removeFromObjStores(string);
    }

    public ObjStore getStore(String string) {
        ObjStore objStore = null;
        String string2 = null;
        for (int i = 0; i < this.objStores.size(); ++i) {
            objStore = (ObjStore)this.objStores.get(i);
            string2 = objStore.getID();
            if (!string.equals(string2)) continue;
            return objStore;
        }
        return null;
    }

    public Vector getOpenStores() {
        return this.getStores(true);
    }

    public Vector getClosedStores() {
        return this.getStores(false);
    }

    private Vector getStores(boolean bl) {
        Vector<ObjStore> vector = new Vector<ObjStore>();
        ObjStore objStore = null;
        if (bl) {
            for (int i = 0; i < this.objStores.size(); ++i) {
                objStore = (ObjStore)this.objStores.get(i);
                if (!objStore.isOpen()) continue;
                vector.addElement(objStore);
            }
        } else {
            for (int i = 0; i < this.objStores.size(); ++i) {
                objStore = (ObjStore)this.objStores.get(i);
                if (objStore.isOpen()) continue;
                vector.addElement(objStore);
            }
        }
        return vector;
    }

    public Vector getAllStores() {
        return this.objStores;
    }

    private boolean idExists(String string) {
        for (int i = 0; i < this.objStores.size(); ++i) {
            String string2 = ((ObjStore)this.objStores.get(i)).getID();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private void removeFromObjStores(String string) {
        for (int i = 0; i < this.objStores.size(); ++i) {
            String string2 = ((ObjStore)this.objStores.get(i)).getID();
            if (!string.equals(string2)) continue;
            this.objStores.remove(i);
            return;
        }
    }

    private static class ObjStoreFactory {
        private ObjStoreFactory() {
        }

        private static ObjStore createStore(ObjStoreAttrs objStoreAttrs) throws ObjStoreException {
            int n = objStoreAttrs.getType();
            if (0 == n) {
                return new JNDIStore(objStoreAttrs);
            }
            throw new ObjStoreTypeNotSupportedException();
        }
    }
}

