/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.guiframework.view;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.TypeConverter;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.sun.enterprise.tools.guiframework.event.descriptors.HandlerDescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.IODescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.UseHandlerDescriptor;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.util.Util;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import java.io.Serializable;
import java.util.EventObject;

public class HandlerContextImpl
implements HandlerContext {
    public static final String OUTPUT_VALUE_SEPARATOR = ".";
    public static final String ATTRIBUTE_TYPE = "attribute";
    public static final String SESSION_TYPE = "session";
    public static final String PAGE_SESSION_TYPE = "pageSession";
    private EventObject _eventObject = null;
    private HandlerDescriptor _handlerDesc = null;
    private UseHandlerDescriptor _useHandlerDesc = null;
    private View _view = null;
    private ViewDescriptor _viewDesc = null;

    protected HandlerContextImpl(UseHandlerDescriptor useHandler, HandlerDescriptor handler, View view, ViewDescriptor vd, EventObject event) {
        this._eventObject = event;
        this._useHandlerDesc = useHandler;
        this._handlerDesc = handler;
        this._view = view;
        this._viewDesc = vd;
    }

    public View getView() {
        return this._view;
    }

    public ViewDescriptor getViewDescriptor() {
        return this._viewDesc;
    }

    public EventObject getEvent() {
        return this._eventObject;
    }

    public UseHandlerDescriptor getUseHandlerDescriptor() {
        return this._useHandlerDesc;
    }

    public HandlerDescriptor getHandlerDescriptor() {
        return this._handlerDesc;
    }

    public Object getInputValue(String name) {
        IODescriptor inDesc = this.getHandlerDescriptor().getInputDescriptor(name);
        if (inDesc == null) {
            throw new FrameworkException("Attempted to get input value '" + name + "', however, this is not a declared input parameter in " + "function '" + this.getHandlerDescriptor().getName() + "'!  Check your" + " handler and/or the XML (near ViewDescriptor '" + this.getViewDescriptor().getName() + "').", this.getViewDescriptor(), this.getView());
        }
        Object value = this.getUseHandlerDescriptor().getInputValue(name);
        if (value == null) {
            value = inDesc.getDefault();
        }
        value = Util.replaceVariablesWithAttributes(value, this.getViewDescriptor());
        value = TypeConverter.asType((Object)inDesc.getType(), (Object)value);
        return value;
    }

    public void setOutputValue(String name, Object value) {
        String targetType;
        String targetKey;
        HandlerDescriptor handler = this.getHandlerDescriptor();
        IODescriptor outDesc = handler.getOutputDescriptor(name);
        if (outDesc == null) {
            throw new FrameworkException("Attempted to set output value '" + name + "' from handler '" + handler.getName() + "', however, this is not " + "a declared output parameter!  Check your handler and/or the " + "XML.", this.getViewDescriptor(), this.getView());
        }
        value = TypeConverter.asType((Object)outDesc.getType(), (Object)value);
        String[] outputParams = this.getUseHandlerDescriptor().getOutputMapping(name);
        if (outputParams == null) {
            targetKey = handler.getName() + OUTPUT_VALUE_SEPARATOR + name;
            targetType = ATTRIBUTE_TYPE;
        } else {
            targetKey = outputParams[0];
            if (targetKey == null) {
                targetKey = handler.getName() + OUTPUT_VALUE_SEPARATOR + name;
            }
            if ((targetType = outputParams[1]) == null) {
                targetType = ATTRIBUTE_TYPE;
            }
        }
        if (targetType.equalsIgnoreCase(ATTRIBUTE_TYPE)) {
            RequestManager.getRequestContext().getRequest().setAttribute(targetKey, value);
        } else if (targetType.equalsIgnoreCase(SESSION_TYPE)) {
            RequestManager.getRequestContext().getRequest().getSession().setAttribute(targetKey, value);
        } else if (targetType.equalsIgnoreCase(PAGE_SESSION_TYPE)) {
            ViewBean vb = Util.getParentViewBean(this.getView());
            vb.setPageSessionAttribute(targetKey, (Serializable)value);
        } else {
            throw new FrameworkException("Invalid target type '" + targetKey + "' used for assigning output from function '" + handler.getName() + "'.", this.getViewDescriptor(), this.getView());
        }
    }

    public Object getOutputValue(String name) {
        Object value;
        String targetType;
        String targetKey;
        HandlerDescriptor handler = this.getHandlerDescriptor();
        IODescriptor outDesc = handler.getOutputDescriptor(name);
        if (outDesc == null) {
            throw new FrameworkException("Attempted to get output value '" + name + "' from handler '" + handler.getName() + "', however, this is not " + "a declared output parameter!  Check your handler and/or the " + "XML.", this.getViewDescriptor(), this.getView());
        }
        String[] outputParams = this.getUseHandlerDescriptor().getOutputMapping(name);
        if (outputParams == null) {
            targetKey = handler.getName() + OUTPUT_VALUE_SEPARATOR + name;
            targetType = ATTRIBUTE_TYPE;
        } else {
            targetKey = outputParams[0];
            if (targetKey == null) {
                targetKey = handler.getName() + OUTPUT_VALUE_SEPARATOR + name;
            }
            if ((targetType = outputParams[1]) == null) {
                targetType = ATTRIBUTE_TYPE;
            }
        }
        if (targetType.equalsIgnoreCase(ATTRIBUTE_TYPE)) {
            value = RequestManager.getRequestContext().getRequest().getAttribute(targetKey);
        } else if (targetType.equalsIgnoreCase(SESSION_TYPE)) {
            value = RequestManager.getRequestContext().getRequest().getSession().getAttribute(targetKey);
        } else if (targetType.equalsIgnoreCase(PAGE_SESSION_TYPE)) {
            ViewBean vb = Util.getParentViewBean(this.getView());
            value = vb.getPageSessionAttribute(targetKey);
        } else {
            throw new FrameworkException("Invalid target type '" + targetKey + "' used for assigning output from function '" + handler.getName() + "'.", this.getViewDescriptor(), this.getView());
        }
        return value;
    }
}

