/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.view.BasicCommandField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.sun.enterprise.tools.admingui.tree.IndexTreeNode;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.FrameworkDescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.EventDescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.HandlerDescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.UseHandlerDescriptor;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.descriptors.BasicCommandFieldDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.FakeContainerDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.web.ui.model.CCBreadCrumbsModel;
import com.sun.web.ui.model.CCBreadCrumbsModelInterface;
import com.sun.web.ui.view.breadcrumb.CCBreadCrumbs;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class CCBreadCrumbsDescriptor
extends ViewDescriptor
implements FakeContainerDescriptor {
    public static final String BREADCRUMB = "BreadCrumb";
    public static final String CHILD_BREADCRUMB_LINK = "BreadCrumbLink";
    public static HandlerDescriptor CLICK_HANDLER = new HandlerDescriptor("BreadCrumbHandler");
    private CCBreadCrumbsModel _model = null;

    public CCBreadCrumbsDescriptor() {
        this(BREADCRUMB);
    }

    public CCBreadCrumbsDescriptor(String name) {
        super(name);
    }

    public View getInstance(RequestContext ctx, ContainerView container, String name) {
        return new CCBreadCrumbs((View)container, this.getModel(), name);
    }

    public void registerChildren(ContainerViewBase instance) {
        super.registerChildren(instance);
        int numberOfCrumbs = this.getNumberOfBreadCrumbs(instance.getParentViewBean().getRequestContext());
        for (int i = 0; i < numberOfCrumbs; ++i) {
            instance.registerChild(CHILD_BREADCRUMB_LINK + i, BasicCommandField.class);
        }
    }

    public int getNumberOfBreadCrumbs(RequestContext ctx) {
        CCBreadCrumbsModelInterface model = this.getModel(ctx);
        if (model == null) {
            return 0;
        }
        return ((DefaultModel)model).getNumRows();
    }

    public CCBreadCrumbsModelInterface getModel() {
        RequestContext rc = RequestManager.getRequestContext();
        return this.getModel(rc);
    }

    protected CCBreadCrumbsModelInterface getModel(RequestContext rc) {
        IndexTreeNode node = Util.getSelectedNode();
        CCBreadCrumbsModelInterface model = (CCBreadCrumbsModelInterface)rc.getModelManager().getModel(CCBreadCrumbsModelInterface.class, node.getPath(), false, false);
        if (model.getCurrentPageLabel() != null) {
            return model;
        }
        model.setCurrentPageLabel(node.getDisplayName());
        Stack stack = this.getNodeStack(node);
        DefaultModel defModel = (DefaultModel)model;
        int crumbCount = 0;
        while (!stack.empty()) {
            node = (IndexTreeNode)stack.pop();
            defModel.appendRow();
            defModel.setValue("commandField", (Object)(CHILD_BREADCRUMB_LINK + crumbCount++));
            defModel.setValue("label", (Object)node.getDisplayName());
            defModel.setValue("status", (Object)node.getDisplayName());
        }
        return model;
    }

    public List getChildDescriptors() {
        ArrayList<ViewDescriptor> descs = new ArrayList<ViewDescriptor>(super.getChildDescriptors());
        Stack stack = this.getNodeStack(Util.getSelectedNode());
        int count = 0;
        while (!stack.empty()) {
            descs.add(this.createChildBreadCrumbDescriptor(CHILD_BREADCRUMB_LINK + count, (IndexTreeNode)stack.pop()));
            ++count;
        }
        return descs;
    }

    protected Stack getNodeStack(IndexTreeNode node) {
        Stack<IndexTreeNode> stack = new Stack<IndexTreeNode>();
        for (node = node.getParent(); node != null; node = node.getParent()) {
            String include = (String)node.getAttribute("includeInBreadCrumb", false);
            if (include != null && include.equals("false")) continue;
            stack.push(node);
        }
        return stack;
    }

    public ViewDescriptor getChildDescriptor(String name) {
        if (name.startsWith(CHILD_BREADCRUMB_LINK)) {
            int linkNum = 0;
            try {
                linkNum = Integer.parseInt(name.substring(CHILD_BREADCRUMB_LINK.length()));
            }
            catch (NumberFormatException ex) {
                throw new FrameworkException("Could not determine link number of: " + name, (Throwable)ex, (ViewDescriptor)this, null);
            }
            Stack stack = this.getNodeStack(Util.getSelectedNode());
            IndexTreeNode node = (IndexTreeNode)stack.get(stack.size() - linkNum - 1);
            return this.createChildBreadCrumbDescriptor(name, node);
        }
        ViewDescriptor desc2 = null;
        for (ViewDescriptor desc2 : super.getChildDescriptors()) {
            if (!desc2.getName().equals(name)) continue;
            return desc2;
        }
        return null;
    }

    protected ViewDescriptor createChildBreadCrumbDescriptor(String name, IndexTreeNode node) {
        BasicCommandFieldDescriptor desc = new BasicCommandFieldDescriptor(name);
        desc.addParameter("treeNode", (Object)node.getPath());
        EventDescriptor event = new EventDescriptor((ViewDescriptor)desc, "command");
        event.addEventHandler(new UseHandlerDescriptor((FrameworkDescriptor)desc, CLICK_HANDLER));
        desc.setEventDescriptor(event);
        desc.setParent((ViewDescriptor)this);
        return desc;
    }

    static {
        CLICK_HANDLER.setHandlerMethod("com.sun.enterprise.tools.admingui.handlers.BreadCrumbHandler", "handleClick");
    }
}

