/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.model;

import com.iplanet.jato.model.ModelFieldChooser;
import com.iplanet.jato.model.ModelFieldInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SimpleModelFieldChooser
extends FeatureDescriptor
implements ModelFieldChooser,
PropertyChangeListener {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ModelFieldInfo[] modelFields;
    private SimpleModelFieldChooserPanel component;
    private String displayName;
    static /* synthetic */ Class class$com$iplanet$jato$model$SimpleModelFieldChooser;

    public SimpleModelFieldChooser() {
    }

    public SimpleModelFieldChooser(ModelFieldInfo[] fields) {
        this();
        this.modelFields = fields == null ? new ModelFieldInfo[]{} : fields;
    }

    public FeatureDescriptor getChooserDescriptor() {
        return this;
    }

    public ModelFieldInfo[] getModelFields() {
        return this.modelFields;
    }

    public void setModelFields(ModelFieldInfo[] value) {
        this.modelFields = value == null ? new ModelFieldInfo[]{} : value;
    }

    public JComponent getChooserComponent() {
        if (this.component == null) {
            this.component = new SimpleModelFieldChooserPanel();
            this.component.addPropertyChangeListener(this);
        }
        return this.component;
    }

    public ModelFieldInfo[] getSelectedFieldInfo() {
        return Arrays.asList(this.component.getSelectedValues()).toArray(new ModelFieldInfo[0]);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.propertyChangeSupport.firePropertyChange(event);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ModelFieldCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private final ImageIcon columnIcon = new ImageIcon((class$com$iplanet$jato$model$SimpleModelFieldChooser == null ? (class$com$iplanet$jato$model$SimpleModelFieldChooser = SimpleModelFieldChooser.class$("com.iplanet.jato.model.SimpleModelFieldChooser")) : class$com$iplanet$jato$model$SimpleModelFieldChooser).getResource("/com/iplanet/jato/resources/column.gif"));

        private ModelFieldCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ModelFieldInfo fieldInfo = (ModelFieldInfo)value;
            String name = fieldInfo.getBoundName();
            if (name == null) {
                name = fieldInfo.getNameExpression();
            }
            this.setIcon(this.columnIcon);
            this.setText(name);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    protected class SimpleModelFieldChooserPanel
    extends JPanel {
        private JScrollPane scrollPane;
        private JList fieldList;
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public SimpleModelFieldChooserPanel() {
            this.initComponents();
        }

        private void initComponents() {
            this.scrollPane = new JScrollPane();
            this.fieldList = new JList();
            this.setLayout(new BorderLayout());
            this.scrollPane.setViewportView(this.fieldList);
            this.add((Component)this.scrollPane, "Center");
            ModelFieldInfo[] fields = SimpleModelFieldChooser.this.getModelFields();
            DefaultListModel<ModelFieldInfo> model = new DefaultListModel<ModelFieldInfo>();
            model.ensureCapacity(fields.length);
            int i = 0;
            while (i < fields.length) {
                ModelFieldInfo fieldInfo = fields[i];
                if (fieldInfo != null) {
                    String name = fieldInfo.getBoundName();
                    if (name == null) {
                        fieldInfo.getNameExpression();
                    }
                    if (name != null) {
                        model.addElement(fields[i]);
                    }
                }
                ++i;
            }
            this.fieldList.setModel(model);
            this.fieldList.setCellRenderer(new ModelFieldCellRenderer());
            this.fieldList.setSelectionMode(2);
            this.fieldList.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ SimpleModelFieldChooserPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void valueChanged(ListSelectionEvent event) {
                    SimpleModelFieldChooserPanel.access$100(this.this$1, event);
                }
            });
            if (model.getSize() > 0) {
                this.fieldList.setSelectedIndex(0);
            }
        }

        private void fieldListValueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting()) {
                this.fireValidSelectionChange(this.fieldList.getSelectedIndex() != -1);
            }
        }

        public Object[] getSelectedValues() {
            return this.fieldList.getSelectedValues();
        }

        protected void fireValidSelectionChange(boolean newValue) {
            this.firePropertyChange("valid", !newValue, newValue);
        }

        static /* synthetic */ void access$100(SimpleModelFieldChooserPanel x0, ListSelectionEvent x1) {
            x0.fieldListValueChanged(x1);
        }
    }
}

