/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.component;

import com.iplanet.jato.util.TypeConverter;
import java.beans.FeatureDescriptor;

public class ConfigPropertyDescriptor
extends FeatureDescriptor {
    public static final String ATTR_PREFERRED_PROPERTY_IMPL_CLASS = "preferredPropertyImplClass";
    public static final String ATTR_UNSET_VALUE_LABEL = "unsetValueLabel";
    public static final String ATTR_ALWAYS_SHOW_UNSET_VALUE_LABEL = "alwaysShowUnsetValueLabel";
    public static final ValuePolicy DEFAULT_POLICY;
    public static final ValuePolicy SHARED_VALUE;
    public static final ValuePolicy DEDICATED_VALUE;
    public static final ValuePolicy DEDICATED_STATIC_VALUE;
    private Class type;
    private Object defaultValue;
    private boolean mandatory;
    private Class propertyEditorClass;
    private ValuePolicy valuePolicy = DEFAULT_POLICY;
    private String[] propertyDependencies;

    public ConfigPropertyDescriptor(String propertyName, Class propertyType) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Parameter \"propertyName\"cannot be null");
        }
        if (propertyType == null) {
            throw new IllegalArgumentException("Parameter \"propertyType\"cannot be null");
        }
        this.setName(propertyName);
        this.setPropertyType(propertyType);
    }

    public Class getPropertyType() {
        return this.type;
    }

    protected void setPropertyType(Class value) {
        this.type = value;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object value) {
        if (this.getPropertyType().isPrimitive() ? TypeConverter.asType(this.getPropertyType(), value) == null : !this.getPropertyType().isInstance(value)) {
            throw new IllegalArgumentException("Default value must be of type " + this.getPropertyType().getName());
        }
        this.defaultValue = value;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean value) {
        this.mandatory = value;
    }

    public ValuePolicy getValuePolicy() {
        return this.valuePolicy;
    }

    public void setValuePolicy(ValuePolicy value) {
        this.valuePolicy = value;
    }

    public Class getPropertyEditorClass() {
        return this.propertyEditorClass;
    }

    public void setPropertyEditorClass(Class value) {
        this.propertyEditorClass = value;
    }

    public String[] getPropertyDependencies() {
        return this.propertyDependencies;
    }

    public void setPropertyDependencies(String[] value) {
        this.propertyDependencies = value;
    }

    static {
        ATTR_PREFERRED_PROPERTY_IMPL_CLASS = ATTR_PREFERRED_PROPERTY_IMPL_CLASS;
        ATTR_UNSET_VALUE_LABEL = ATTR_UNSET_VALUE_LABEL;
        ATTR_ALWAYS_SHOW_UNSET_VALUE_LABEL = ATTR_ALWAYS_SHOW_UNSET_VALUE_LABEL;
        DEFAULT_POLICY = new ValuePolicy("defaultPolicy");
        SHARED_VALUE = new ValuePolicy("shared");
        DEDICATED_VALUE = new ValuePolicy("dedicated");
        DEDICATED_STATIC_VALUE = new ValuePolicy("dedicatedStatic");
    }

    public static final class ValuePolicy {
        private String discriminator;

        private ValuePolicy(String discriminator) {
            this.discriminator = discriminator;
        }

        public String toString() {
            return this.discriminator;
        }

        public int hashCode() {
            return this.discriminator.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            return other instanceof ValuePolicy && ((ValuePolicy)other).discriminator.equals(this.discriminator);
        }
    }
}

