/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.j2ee;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.j2ee.Servlet;
import com.sun.appserv.management.j2ee.WebModule;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.enterprise.management.j2ee.J2EEModuleImplBase;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.WebModuleSupport;
import java.util.Map;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebModuleImpl
extends J2EEModuleImplBase {
    public WebModuleImpl(Delegate delegate) {
        super(delegate);
    }

    @Override
    protected String getConfigPeerName() {
        String compositeName = this.getName();
        String webModuleName = WebModuleSupport.extractWebModuleName(compositeName);
        return webModuleName;
    }

    @Override
    public boolean isConfigProvider() {
        String name;
        boolean isConfigProvider = super.isConfigProvider();
        if (super.isConfigProvider() && this.getObjectName() != null && ((name = this.getConfigPeerName()).length() == 0 || name.equals("asadmin") || name.equals("web1"))) {
            isConfigProvider = false;
        }
        return isConfigProvider;
    }

    protected WebModule getSelfProxy() {
        return (WebModule)this.getSelf();
    }

    public String[] getservlets() {
        Map<String, Servlet> servlets = this.getSelfProxy().getServletMap();
        return CollectionUtil.toStringArray(Util.toObjectNames(servlets).values());
    }

    public Map getServletObjectNameMap() {
        return this.getContaineeObjectNameMap("Servlet");
    }

    @Override
    protected String getMonitoringPeerJ2EEType() {
        return "X-WebModuleVirtualServerMonitor";
    }

    private final String deduceModuleName() {
        int index2;
        String workDir = this.getSelfProxy().getWorkDir();
        int index1 = workDir.lastIndexOf("/");
        int index = index1 > (index2 = workDir.lastIndexOf("\\")) ? index1 : index2;
        String result = null;
        if (index > 0) {
            result = workDir.substring(index + 1, workDir.length());
        }
        return result;
    }

    @Override
    protected ObjectName queryConfigPeerFailed(Map<String, String> propsMap) {
        String potentialName = this.deduceModuleName();
        propsMap.put("name", potentialName);
        ObjectName result = this.queryProps(propsMap);
        return result;
    }

    @Override
    protected ObjectName queryMonitoringPeerFailed(Map<String, String> propsMap) {
        String selfName = this.getName();
        String virtualServerName = WebModuleSupport.extractVirtualServerName(selfName);
        ObjectName result = null;
        String potentialName = this.deduceModuleName();
        if (potentialName != null) {
            String name = WebModuleSupport.formCompositeName(virtualServerName, potentialName);
            propsMap.put("name", name);
            result = this.queryProps(propsMap);
        }
        return result;
    }
}

