/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.ProviderConfig;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import java.util.logging.Level;

public class ProviderConfigTest
extends GenericValidator {
    private static final char[] illegalChars = new char[]{'*', ',', ':'};

    public ProviderConfigTest(ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce);
        try {
            if (cce.getChoice().equals("DELETE") && this.isReferencedByParent(cce)) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".cannotDeleteReferencedProviderConfig", "provider config (provider-id={0}) can not be removed. It is referenced by its parent message-security-config", new Object[]{this.getProviderConfig(cce).getProviderId()}));
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "domainxmlverifier.exception", e);
        }
        return result;
    }

    private final boolean isReferencedByParent(ConfigContextEvent cce) throws ConfigException {
        ProviderConfig pc = this.getProviderConfig(cce);
        MessageSecurityConfig msc = (MessageSecurityConfig)pc.parent().parent();
        return msc.getDefaultProvider() != null && msc.getDefaultProvider().equals(pc.getProviderId());
    }

    private ProviderConfig getProviderConfig(ConfigContextEvent cce) throws ConfigException {
        return (ProviderConfig)cce.getValidationTarget();
    }
}

