/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.registry.spi;

import com.sun.enterprise.admin.common.ObjectNames;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class DottedNameRegistrar {
    final MBeanServer server;
    final ObjectName registryName;
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");

    DottedNameRegistrar(MBeanServer server) {
        this.server = server;
        this.registryName = ObjectNames.getDottedNameMonitoringRegistryObjectName();
    }

    void registerDottedName(String dottedName, ObjectName objectName) {
        try {
            this.server.invoke(this.registryName, "add", new Object[]{dottedName, objectName}, new String[]{String.class.getName(), ObjectName.class.getName()});
        }
        catch (Exception e) {
            logger.fine(e.getClass().getName() + ":" + e.getLocalizedMessage());
        }
    }

    void unregisterDottedName(String dottedName) {
        try {
            this.server.invoke(this.registryName, "remove", new Object[]{dottedName}, new String[]{String.class.getName()});
        }
        catch (Exception e) {
            logger.fine(e.getClass().getName() + ":" + e.getLocalizedMessage());
        }
    }
}

