/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.common;

import com.sun.enterprise.util.LocalStringsImpl;
import java.io.Serializable;

public class Status
implements Serializable {
    public static final long serialVersionUID = -211313166471337363L;
    public static final int kInstanceRunningCode = 0;
    public static final int kInstanceStartingCode = 1;
    public static final int kInstanceStoppingCode = 2;
    public static final int kInstanceNotRunningCode = 3;
    public static final int kEntityEnabledCode = 4;
    public static final int kEntityDisabledCode = 5;
    public static final int kClusterPartiallyRunningCode = 6;
    public static final int kInstanceSynchronizingCode = 7;
    public static final int kInstanceFailedCode = 8;
    public static final String kInstanceRunningMsg;
    public static final String kInstanceStartingMsg;
    public static final String kInstanceStoppingMsg;
    public static final String kInstanceNotRunningMsg;
    public static final String kUnknownStateMsg;
    public static final String kPartiallyRunningMsg;
    public static final String kInstanceSynchronizingMsg;
    public static final String kInstanceFailedMsg;
    protected int mStatusCode;
    protected String mStatusString;

    protected Status() {
    }

    public Status(int code, String str) {
        this.mStatusCode = code;
        this.mStatusString = str;
    }

    public Status(int code) {
        this.mStatusCode = code;
        this.mStatusString = Status.getStatusString(code);
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    public String getStatusString() {
        return this.mStatusString;
    }

    public String toString() {
        return this.mStatusCode + " : " + this.mStatusString;
    }

    public static String getStatusString(int code) {
        String status = kUnknownStateMsg;
        switch (code) {
            case 3: {
                status = kInstanceNotRunningMsg;
                break;
            }
            case 0: {
                status = kInstanceRunningMsg;
                break;
            }
            case 1: {
                status = kInstanceStartingMsg;
                break;
            }
            case 8: {
                status = kInstanceFailedMsg;
                break;
            }
            case 2: {
                status = kInstanceStoppingMsg;
                break;
            }
            case 6: {
                status = kPartiallyRunningMsg;
                break;
            }
            case 7: {
                status = kInstanceSynchronizingMsg;
                break;
            }
        }
        return status;
    }

    static {
        String pre = "admin.common.status.";
        LocalStringsImpl ls = new LocalStringsImpl();
        kInstanceRunningMsg = ls.get(pre + "0");
        kInstanceStartingMsg = ls.get(pre + "1");
        kInstanceStoppingMsg = ls.get(pre + "2");
        kInstanceNotRunningMsg = ls.get(pre + "3");
        kUnknownStateMsg = ls.get(pre + "4");
        kPartiallyRunningMsg = ls.get(pre + "6");
        kInstanceSynchronizingMsg = ls.get(pre + "7");
        kInstanceFailedMsg = ls.get(pre + "8");
    }
}

