/*
 * Decompiled with CFR 0.152.
 */
package persistence.antlr.preprocessor;

import java.util.Enumeration;
import persistence.antlr.collections.impl.IndexedVector;
import persistence.antlr.preprocessor.Grammar;
import persistence.antlr.preprocessor.Option;

class Rule {
    protected String name;
    protected String block;
    protected String args;
    protected String returnValue;
    protected String throwsSpec;
    protected String initAction;
    protected IndexedVector options;
    protected String visibility;
    protected Grammar enclosingGrammar;
    protected boolean bang = false;

    public Rule(String n, String b, IndexedVector options, Grammar gr) {
        this.name = n;
        this.block = b;
        this.options = options;
        this.setEnclosingGrammar(gr);
    }

    public String getArgs() {
        return this.args;
    }

    public boolean getBang() {
        return this.bang;
    }

    public String getName() {
        return this.name;
    }

    public String getReturnValue() {
        return this.returnValue;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public boolean narrowerVisibility(Rule rule) {
        if (this.visibility.equals("public")) {
            return !rule.equals("public");
        }
        if (this.visibility.equals("protected")) {
            return rule.equals("private");
        }
        if (this.visibility.equals("private")) {
            return false;
        }
        return false;
    }

    public boolean sameSignature(Rule rule) {
        boolean nSame = true;
        boolean aSame = true;
        boolean rSame = true;
        nSame = this.name.equals(rule.getName());
        if (this.args != null) {
            aSame = this.args.equals(rule.getArgs());
        }
        if (this.returnValue != null) {
            rSame = this.returnValue.equals(rule.getReturnValue());
        }
        return nSame && aSame && rSame;
    }

    public void setArgs(String a) {
        this.args = a;
    }

    public void setBang() {
        this.bang = true;
    }

    public void setEnclosingGrammar(Grammar g) {
        this.enclosingGrammar = g;
    }

    public void setInitAction(String a) {
        this.initAction = a;
    }

    public void setOptions(IndexedVector options) {
        this.options = options;
    }

    public void setReturnValue(String ret) {
        this.returnValue = ret;
    }

    public void setThrowsSpec(String t) {
        this.throwsSpec = t;
    }

    public void setVisibility(String v) {
        this.visibility = v;
    }

    public String toString() {
        String s = "";
        String retString = this.returnValue == null ? "" : "returns " + this.returnValue;
        String argString = this.args == null ? "" : this.args;
        String bang = this.getBang() ? "!" : "";
        s = s + (this.visibility == null ? "" : this.visibility + " ");
        s = s + this.name + bang + argString + " " + retString + this.throwsSpec;
        if (this.options != null) {
            s = s + System.getProperty("line.separator") + "options {" + System.getProperty("line.separator");
            Enumeration e = this.options.elements();
            while (e.hasMoreElements()) {
                s = s + (Option)e.nextElement() + System.getProperty("line.separator");
            }
            s = s + "}" + System.getProperty("line.separator");
        }
        if (this.initAction != null) {
            s = s + this.initAction + System.getProperty("line.separator");
        }
        s = s + this.block;
        return s;
    }
}

