/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote.streams;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class JMXChunkedOutputStream
extends OutputStream {
    private OutputStream out = null;
    private byte[] buffer = null;
    private int bufCount = 0;

    public JMXChunkedOutputStream(OutputStream out) {
        this.out = out;
        this.buffer = new byte[8192];
    }

    public void close() throws IOException {
        if (this.bufCount > 0) {
            this.flush();
        }
        this.out.close();
    }

    public void flush() throws IOException {
        if (this.bufCount > 0) {
            this.flushBuffer();
        } else {
            this.out.flush();
        }
    }

    private void flushBuffer() throws IOException {
        this.writeObject(this.buffer, 0, this.bufCount);
        this.bufCount = 0;
    }

    public void writeEOF(int padLen) throws IOException {
        DataOutputStream dO = new DataOutputStream(this.out);
        dO.writeInt(0);
        dO.write(new byte[padLen], 0, padLen);
        dO.flush();
    }

    public void write(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException("byte array is null");
        }
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("byte array is null");
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("offset=" + off + ", len=" + len + ", (off+len)=" + (off + len) + ", b.length=" + b.length + ", (off+len)>b.length=" + (off + len > b.length));
        }
        if (len == 0) {
            return;
        }
        if (this.bufCount > 0 && this.bufCount + len >= 8192) {
            this.flushBuffer();
        }
        if (len >= 8192) {
            this.writeObject(b, off, len);
            return;
        }
        this.writeBuffer(b, off, len);
    }

    public void write(int by) throws IOException {
        byte b = (byte)by;
        if (this.bufCount > 0 && this.bufCount + 1 >= 8192) {
            this.flushBuffer();
        }
        this.buffer[this.bufCount] = b;
        ++this.bufCount;
    }

    private void writeBuffer(byte[] b, int off, int len) {
        System.arraycopy(b, off, this.buffer, this.bufCount, len);
        this.bufCount += len;
    }

    private void writeObject(byte[] b, int off, int len) throws IOException {
        DataOutputStream dO = new DataOutputStream(this.out);
        dO.writeInt(len);
        dO.write(b, off, len);
        dO.flush();
    }
}

