/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.util;

import com.sun.genericra.util.ExceptionUtils;
import com.sun.genericra.util.LogUtils;
import com.sun.genericra.util.ObjectBuilder;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.resource.ResourceException;

public class ObjectBuilderFactory {
    private static boolean debug = false;
    private static Logger logger = LogUtils.getLogger();

    public ObjectBuilder createUsingClassName(String name) {
        return new ClassObjectBuilder(name);
    }

    public ObjectBuilder createUsingJndiName(String jndiName, String jndiProps) {
        return new JndiObjectBuilder(jndiName, jndiProps);
    }

    void debug(String str) {
        logger.log(Level.FINEST, str);
    }

    class JndiObjectBuilder
    extends ObjectBuilder {
        private String jndiName = null;
        private String jndiProps = null;

        JndiObjectBuilder(String jndiName, String jndiProps) {
            this.jndiName = jndiName;
            this.jndiProps = jndiProps;
        }

        public Object createObject() throws ResourceException {
            try {
                Hashtable props = this.parseToProperties(this.jndiProps);
                ObjectBuilderFactory.this.debug("Properties passed to InitialContext :: " + props);
                InitialContext ic = new InitialContext(props);
                ObjectBuilderFactory.this.debug("Looking the JNDI name :" + this.jndiName);
                return ic.lookup(this.jndiName);
            }
            catch (Exception e) {
                throw ExceptionUtils.newInvalidPropertyException(e);
            }
        }
    }

    class ClassObjectBuilder
    extends ObjectBuilder {
        private String className = null;

        public ClassObjectBuilder(String className) {
            this.className = className;
        }

        public Object createObject() throws ResourceException {
            try {
                return Class.forName(this.className).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw ExceptionUtils.newInvalidPropertyException(e);
            }
            catch (InstantiationException ie) {
                throw ExceptionUtils.newInvalidPropertyException(ie);
            }
            catch (IllegalAccessException iae) {
                throw ExceptionUtils.newSecurityException(iae);
            }
        }
    }
}

