/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.outbound;

import com.sun.genericra.GenericJMSRA;
import com.sun.genericra.GenericJMSRAProperties;
import com.sun.genericra.util.ExceptionUtils;
import com.sun.genericra.util.LogUtils;
import com.sun.genericra.util.ObjectBuilder;
import com.sun.genericra.util.ObjectBuilderFactory;
import com.sun.genericra.util.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.resource.ResourceException;

public abstract class DestinationAdapter
extends GenericJMSRAProperties
implements Destination {
    private String destinationProperties = null;
    private String jndiName = null;
    private Destination physicalDestination;
    private static Logger logger = LogUtils.getLogger();

    public DestinationAdapter() {
        DestinationAdapter.debug("Destination adapter is created");
    }

    public Destination _getPhysicalDestination() throws JMSException {
        logger.log(Level.FINEST, "Returning physical destintion " + this.physicalDestination);
        if (this.physicalDestination == null) {
            try {
                this.initialize();
            }
            catch (ResourceException re) {
                throw ExceptionUtils.newJMSException(re);
            }
        }
        if (logger.isLoggable(Level.FINEST) && this.physicalDestination != null) {
            logger.log(Level.FINEST, "Physical destintion type" + this.physicalDestination.getClass().getName());
        }
        return this.physicalDestination;
    }

    private void initialize() throws ResourceException {
        this.setResourceAdapter(GenericJMSRA.getInstance());
        ObjectBuilder destBuilder = null;
        ObjectBuilderFactory obf = new ObjectBuilderFactory();
        if (this.getProviderIntegrationMode().equalsIgnoreCase("jndi")) {
            DestinationAdapter.debug("Creating destination using jndiName " + this.jndiName);
            destBuilder = obf.createUsingJndiName(this.getDestinationJndiName(), this.getJndiProperties());
        } else {
            destBuilder = obf.createUsingClassName(this.getDestinationClassName());
            destBuilder.setProperties(this.getDestinationProperties());
        }
        String setMethod = this.getCommonSetterMethodName();
        if (!StringUtils.isNull(setMethod)) {
            destBuilder.setCommonSetterMethodName(setMethod);
        }
        this.physicalDestination = (Destination)destBuilder.build();
    }

    protected abstract String getDestinationClassName();

    public void setDestinationJndiName(String jndiName) {
        DestinationAdapter.debug("Destination Jndi Name is set as " + jndiName);
        this.jndiName = jndiName;
    }

    public String getDestinationJndiName() {
        return this.jndiName;
    }

    public String getDestinationProperties() {
        return this.destinationProperties;
    }

    public void setDestinationProperties(String destinationProperties) {
        DestinationAdapter.debug("Setting destination properties : " + destinationProperties);
        if (!StringUtils.isNull(destinationProperties)) {
            this.destinationProperties = destinationProperties;
            try {
                this.initialize();
            }
            catch (ResourceException e) {
                DestinationAdapter.debug("Cannot create Destination " + (Object)((Object)e));
            }
        }
    }

    private static void debug(String string) {
        logger.log(Level.FINEST, "[Destination]" + string);
    }

    public String toString() {
        if (this.physicalDestination != null) {
            return this.physicalDestination.toString();
        }
        return super.toString();
    }
}

