/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HealthCheckerConfigFactory
extends ConfigFactory {
    private final Set<String> LEGAL_OPTIONAL_KEYS = GSetUtil.newUnmodifiableStringSet("url", "interval-in-seconds", "timeout-in-seconds");

    public HealthCheckerConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    @Override
    protected Set<String> getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }

    @Override
    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        String containerName = this.getFactoryContainer().getName();
        if (this.getFactoryContainer().getJ2EEType().equals("X-ClusterRefConfig")) {
            return this.getOldConfigProxies().getOldClusterRefMBean(containerName).createHealthChecker(translatedAttrs);
        }
        if (this.getFactoryContainer().getJ2EEType().equals("X-ServerRefConfig")) {
            return this.getOldConfigProxies().getOldServerRefMBean(containerName).createHealthChecker(translatedAttrs);
        }
        return null;
    }

    public ObjectName create(String url, String intervalInSeconds, String timeoutInSeconds) {
        HashMap<String, String> optional = new HashMap<String, String>();
        optional.put("url", url);
        optional.put("interval-in-seconds", intervalInSeconds);
        optional.put("timeout-in-seconds", timeoutInSeconds);
        Map<String, String> params = this.initParams(optional);
        ObjectName amxName = this.createChild(params);
        return amxName;
    }

    public void remove(String name) {
        String containerName = this.getFactoryContainer().getName();
        if (this.getFactoryContainer().getJ2EEType().equals("X-ClusterRefConfig")) {
            this.getOldConfigProxies().getOldClusterRefMBean(containerName).removeHealthChecker();
        } else if (this.getFactoryContainer().getJ2EEType().equals("X-ServerRefConfig")) {
            this.getOldConfigProxies().getOldServerRefMBean(containerName).removeHealthChecker();
        }
    }
}

