/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.serverbeans.Event;
import com.sun.enterprise.config.serverbeans.ManagementRule;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.ValidationContext;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import java.util.Arrays;
import java.util.List;

public class ManagementRuleTest
extends GenericValidator {
    static final List EVENT_TYPES = Arrays.asList("log", "timer", "trace", "monitor", "cluster", "lifecycle", "notification");
    static final List LOG_LEVELS = Arrays.asList("FINEST", "FINER", "FINE", "CONFIG", "INFO", "WARNING", "SEVERE", "OFF");

    public ManagementRuleTest(ValidationDescriptor desc) {
        super(desc);
    }

    public void validateElement(ValidationContext valCtx) {
        super.validateElement(valCtx);
        if ((valCtx.isADD() || valCtx.isSET()) && valCtx.value instanceof ManagementRule) {
            try {
                Event event = ((ManagementRule)valCtx.value).getEvent();
                if (!EVENT_TYPES.contains(event.getType())) {
                    valCtx.result.failed(this.smh.getLocalString(this.getClass().getName(), valCtx.smh.getLocalString(this.getClass().getName() + ".wrongEventType", "Value {0} is not allowed for Event type", new Object[]{event.getType()})));
                }
                if (!LOG_LEVELS.contains(event.getLevel())) {
                    valCtx.result.failed(this.smh.getLocalString(this.getClass().getName(), valCtx.smh.getLocalString(this.getClass().getName() + ".wrongEventLevel", "Value {0} is not allowed for Event log level", new Object[]{event.getLevel()})));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

