/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.agent;

import com.sun.enterprise.admin.wsmgmt.WebServiceMgrBackEnd;
import com.sun.enterprise.admin.wsmgmt.config.spi.ConfigFactory;
import com.sun.enterprise.admin.wsmgmt.config.spi.ConfigProvider;
import com.sun.enterprise.admin.wsmgmt.config.spi.WebServiceConfig;
import com.sun.enterprise.admin.wsmgmt.stats.impl.WebServiceEndpointStatsProviderImpl;
import com.sun.enterprise.admin.wsmgmt.stats.spi.StatsProviderManager;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.webservice.monitoring.AuthenticationListener;
import com.sun.enterprise.webservice.monitoring.Endpoint;
import java.security.Principal;
import java.util.logging.Logger;

public class AuthenticationListenerImpl
implements AuthenticationListener {
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private ConfigProvider cfgProv = null;
    private static final StringManager _stringMgr = StringManager.getManager(AuthenticationListenerImpl.class);

    public AuthenticationListenerImpl() {
        try {
            this.cfgProv = ConfigFactory.getConfigFactory().getConfigProvider();
        }
        catch (Exception e) {
            _logger.fine("Config provider could not be initialized " + e.getMessage());
        }
    }

    public void authSucess(BundleDescriptor desc, Endpoint ep, Principal principal) {
    }

    public void authFailure(BundleDescriptor desc, Endpoint ep, Principal principal) {
        if (ep == null) {
            _logger.fine("Endpoint is null for " + desc.getModuleID());
            return;
        }
        String fqn = WebServiceMgrBackEnd.getManager().getFullyQualifiedName(ep);
        if (fqn == null) {
            _logger.fine("Fully Qualified could not be computed for the selector " + ep.getEndpointSelector());
            return;
        }
        WebServiceConfig wsc = this.cfgProv.getWebServiceConfig(fqn);
        if (wsc == null || wsc.getMonitoringLevel() == null || wsc.getMonitoringLevel().equals("OFF")) {
            _logger.fine("Monitoring is OFF for webservice endpoint " + fqn);
            return;
        }
        WebServiceEndpointStatsProviderImpl impl = (WebServiceEndpointStatsProviderImpl)StatsProviderManager.getInstance().getEndpointStatsProvider(fqn);
        if (impl == null) {
            if (this.cfgProv != null) {
                String msg = _stringMgr.getString("Auth.StatsNotReg", (Object)fqn);
                throw new RuntimeException(msg);
            }
            return;
        }
        impl.setAuthFailure(System.currentTimeMillis());
    }
}

