/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import java.util.NoSuchElementException;

public class QuotedStringTokenizer {
    private final char[] ca;
    private String delimiters = "\t ";
    private final int numTokens;
    private int curToken = 0;
    private final CharIterator iterator;

    public QuotedStringTokenizer(String s) {
        this(s, null);
    }

    public QuotedStringTokenizer(String s, String delim) {
        if (null == s) {
            throw new IllegalArgumentException("null param");
        }
        this.ca = s.toCharArray();
        if (delim != null && delim.length() > 0) {
            this.delimiters = delim;
        }
        this.numTokens = this._countTokens();
        this.iterator = new CharIterator(this.ca);
    }

    public int countTokens() {
        return this.numTokens;
    }

    public boolean hasMoreTokens() {
        return this.curToken < this.numTokens;
    }

    public String nextToken() {
        char c;
        if (this.curToken == this.numTokens) {
            throw new NoSuchElementException();
        }
        StringBuffer sb = new StringBuffer();
        boolean bQuote = false;
        boolean bEscaped = false;
        while ((c = this.iterator.next()) != '\uffff') {
            boolean isDelimiter = this.isDelimiter(c);
            if (!isDelimiter && !bEscaped) {
                char next;
                sb.append(c);
                if (c == '\"') {
                    boolean bl = bQuote = !bQuote;
                }
                if ((next = this.iterator.peekNext()) == '\uffff' || this.isDelimiter(next) && !bQuote) {
                    break;
                }
            } else if (bQuote || bEscaped) {
                sb.append(c);
            }
            if (c == '\\') {
                bEscaped = !bEscaped;
                continue;
            }
            bEscaped = false;
        }
        ++this.curToken;
        return sb.toString();
    }

    boolean isDelimiter(char c) {
        return this.delimiters.indexOf(c) >= 0;
    }

    private int _countTokens() {
        char c;
        int tokens = 0;
        boolean bQuote = false;
        boolean bEscaped = false;
        CharIterator it = new CharIterator(this.ca);
        while ((c = it.next()) != '\uffff') {
            char next = it.peekNext();
            if (!this.isDelimiter(c) && !bEscaped) {
                if (c == '\"') {
                    boolean bl = bQuote = !bQuote;
                }
                if (next == '\uffff' || this.isDelimiter(next) && !bQuote) {
                    ++tokens;
                }
            } else if (next == '\uffff' && bQuote) {
                ++tokens;
            }
            if (c == '\\') {
                bEscaped = !bEscaped;
                continue;
            }
            bEscaped = false;
        }
        return tokens;
    }

    private static final class CharIterator {
        static final char EOF = '\uffff';
        private final char[] carr;
        private int index = 0;

        private CharIterator(char[] ca) {
            this.carr = ca;
        }

        char next() {
            if (this.index >= this.carr.length) {
                return '\uffff';
            }
            char c = this.carr[this.index];
            ++this.index;
            return c;
        }

        char peekNext() {
            if (this.index >= this.carr.length) {
                return '\uffff';
            }
            return this.carr[this.index];
        }
    }
}

