/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.GenericCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CLITokenizer;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;

public class DisplayLogRecordsCommand
extends GenericCommand {
    private static final String TIMESTAMP_OPTION = "timestamp";
    private static final String MODULEID_OPTION = "moduleid";
    private static final String LEVEL_OPTION = "errorlevel";
    private static final String MODULE_DELIMITER = ":";

    protected Object[] getParamsInfo() throws CommandException, CommandValidationException {
        Object[] paramsInfo = new Object[11];
        long timestamp = new Long(this.getOption(TIMESTAMP_OPTION));
        String errorLevel = this.getOption(LEVEL_OPTION);
        paramsInfo[0] = null;
        paramsInfo[1] = null;
        paramsInfo[2] = Boolean.FALSE;
        paramsInfo[3] = Boolean.FALSE;
        paramsInfo[4] = new Integer(1000);
        paramsInfo[5] = new Date(timestamp);
        paramsInfo[6] = new Date(timestamp + 3600000L);
        paramsInfo[7] = errorLevel == null ? Level.WARNING.toString() : errorLevel;
        paramsInfo[8] = errorLevel != null ? Boolean.TRUE : Boolean.FALSE;
        paramsInfo[9] = this.getModuleIds();
        paramsInfo[10] = null;
        for (Object param : paramsInfo) {
            if (param != null) {
                CLILogger.getInstance().printDebugMessage(param.toString());
                continue;
            }
            CLILogger.getInstance().printDebugMessage("null");
        }
        return paramsInfo;
    }

    protected void handleReturnValue(Object retVal) {
        AttributeList results = (AttributeList)retVal;
        List headerRow = (List)((Attribute)results.get(0)).getValue();
        List rowList = (List)((Attribute)results.get(1)).getValue();
        Iterator it = rowList.iterator();
        if (it.hasNext()) {
            CLILogger.getInstance().printDetailMessage("----------------------------------------------------------------------");
        } else {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("NoElementsToList"));
        }
        while (it.hasNext()) {
            List row = (List)it.next();
            if (row.size() != headerRow.size()) {
                CLILogger.getInstance().printDebugMessage("Row had '" + row.size() + "' columns, header has '" + headerRow.size() + "' columns!");
            }
            CLILogger.getInstance().printMessage(this.getLocalizedString("LogRecNumber") + " = " + row.get(0));
            CLILogger.getInstance().printMessage(this.getLocalizedString("LogDateTime") + " = " + row.get(1));
            CLILogger.getInstance().printMessage(this.getLocalizedString("LogMsgId") + " = " + row.get(6));
            CLILogger.getInstance().printMessage(this.getLocalizedString("LogLevel") + " = " + row.get(2));
            CLILogger.getInstance().printMessage(this.getLocalizedString("LogProductName") + " = " + row.get(3));
            CLILogger.getInstance().printMessage(this.getLocalizedString("LogLogger") + " = " + row.get(4));
            CLILogger.getInstance().printMessage(this.getLocalizedString("Lognvp") + " = " + row.get(5));
            CLILogger.getInstance().printMessage(this.getLocalizedString("LogMessage") + " = " + row.get(7));
            CLILogger.getInstance().printDetailMessage("----------------------------------------------------------------------");
        }
    }

    protected List getModuleIds() throws CommandException, CommandValidationException {
        ArrayList<String> moduleIds = new ArrayList<String>();
        String modulesStr = (String)this.getOperands().get(0);
        CLITokenizer modulesTok = new CLITokenizer(modulesStr, MODULE_DELIMITER);
        while (modulesTok.hasMoreTokens()) {
            moduleIds.add(modulesTok.nextToken());
        }
        return moduleIds;
    }
}

