/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.mappings.converters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import oracle.toplink.essentials.exceptions.ConversionException;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.CustomObjectInputStream;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.converters.Converter;
import oracle.toplink.essentials.mappings.foundation.AbstractDirectMapping;
import oracle.toplink.essentials.sessions.Session;

public class SerializedObjectConverter
implements Converter {
    protected DatabaseMapping mapping;

    public SerializedObjectConverter() {
    }

    public SerializedObjectConverter(DatabaseMapping mapping) {
        this.mapping = mapping;
    }

    public Object convertDataValueToObjectValue(Object fieldValue, Session session) throws DescriptorException {
        byte[] bytes;
        try {
            bytes = (byte[])((AbstractSession)session).getDatasourcePlatform().convertObject(fieldValue, ClassConstants.APBYTE);
        }
        catch (ConversionException e) {
            throw ConversionException.couldNotBeConverted((Object)this.mapping, this.mapping.getDescriptor(), e);
        }
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayInputStream byteIn = new ByteArrayInputStream(bytes);
        Object object = null;
        try {
            CustomObjectInputStream objectIn = new CustomObjectInputStream(byteIn, session);
            object = objectIn.readObject();
        }
        catch (Exception exception) {
            throw DescriptorException.notDeserializable(this.getMapping(), exception);
        }
        return object;
    }

    public Object convertObjectValueToDataValue(Object attributeValue, Session session) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);
            objectOut.writeObject(attributeValue);
            objectOut.flush();
        }
        catch (IOException exception) {
            throw DescriptorException.notSerializable(this.getMapping(), exception);
        }
        return byteOut.toByteArray();
    }

    public void initialize(DatabaseMapping mapping, Session session) {
        AbstractDirectMapping directMapping;
        this.mapping = mapping;
        if (this.getMapping().isDirectToFieldMapping() && (directMapping = (AbstractDirectMapping)this.getMapping()).getFieldClassification() == null) {
            directMapping.setFieldClassification(ClassConstants.APBYTE);
        }
    }

    protected DatabaseMapping getMapping() {
        return this.mapping;
    }

    public boolean isMutable() {
        return true;
    }
}

