/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.persistence.JoinTable;
import javax.persistence.MapKey;
import javax.persistence.OrderBy;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.RelationshipAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataJoinColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataJoinColumns;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.tables.MetadataJoinTable;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.queryframework.CollectionContainerPolicy;
import oracle.toplink.essentials.mappings.CollectionMapping;
import oracle.toplink.essentials.mappings.ManyToManyMapping;

public abstract class CollectionAccessor
extends RelationshipAccessor {
    public CollectionAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
    }

    protected void addManyToManyRelationKeyFields(MetadataJoinColumns joinColumns, ManyToManyMapping mapping, String defaultFieldName, MetadataDescriptor descriptor, boolean isSource) {
        String FK_CTX;
        String PK_CTX;
        if (isSource) {
            PK_CTX = "metadata_default_source_pk_column";
            FK_CTX = "metadata_default_source_fk_column";
        } else {
            PK_CTX = "metadata_default_target_pk_column";
            FK_CTX = "metadata_default_target_fk_column";
        }
        for (MetadataJoinColumn joinColumn : this.processJoinColumns(joinColumns, descriptor)) {
            String defaultPKFieldName = descriptor.getPrimaryKeyFieldName();
            DatabaseField pkField = joinColumn.getPrimaryKeyField();
            pkField.setName(this.getName(pkField, defaultPKFieldName, PK_CTX));
            pkField.setTableName(descriptor.getPrimaryTableName());
            DatabaseField fkField = joinColumn.getForeignKeyField();
            String defaultFKFieldName = defaultFieldName + "_" + defaultPKFieldName;
            fkField.setName(this.getName(fkField, defaultFKFieldName, FK_CTX));
            fkField.setTableName(mapping.getRelationTableQualifiedName());
            if (isSource) {
                mapping.addSourceRelationKeyField(fkField, pkField);
                continue;
            }
            mapping.addTargetRelationKeyField(fkField, pkField);
        }
    }

    protected MetadataJoinTable getJoinTable() {
        JoinTable joinTable = (JoinTable)this.getAnnotation(JoinTable.class);
        return new MetadataJoinTable(joinTable);
    }

    public String getMapKey() {
        if (this.isAnnotationPresent(MapKey.class)) {
            MapKey mapKey = (MapKey)this.getAnnotation(MapKey.class);
            return mapKey.name();
        }
        return "";
    }

    public String getOrderBy() {
        OrderBy orderBy = (OrderBy)this.getAnnotation(OrderBy.class);
        return orderBy.value();
    }

    public boolean hasOrderBy() {
        return this.isAnnotationPresent(OrderBy.class);
    }

    public boolean isMapCollectionAccessor() {
        return this.getRawClass().equals(Map.class);
    }

    protected void populateCollectionMapping(CollectionMapping mapping, String context) {
        mapping.setIsReadOnly(false);
        mapping.setIsPrivateOwned(false);
        mapping.setAttributeName(this.getAttributeName());
        this.setAccessorMethods(mapping);
        this.processCascadeTypes(mapping);
        this.setReferenceClass(this.getTargetEntity(), context);
        mapping.setReferenceClassName(this.getReferenceClassName());
        this.processOrderBy(mapping);
        String mapKey = this.processMapKey(mapping);
        this.setIndirectionPolicy(mapping, mapKey);
    }

    protected void processJoinTable(MetadataJoinTable joinTable, ManyToManyMapping mapping) {
        String sourceName = Helper.getShortClassName(this.getJavaClassName()).toUpperCase();
        String targetName = Helper.getShortClassName(this.getReferenceClassName()).toUpperCase();
        String defaultName = sourceName + "_" + targetName;
        String name = this.getName(joinTable.getName(), defaultName, "metadata_default_join_table_name");
        String catalog = this.getName(joinTable.getCatalog(), this.m_descriptor.getCatalog(), "metadata_default_join_table_catalog");
        String schema = this.getName(joinTable.getSchema(), this.m_descriptor.getSchema(), "metadata_default_join_table_schema");
        joinTable.setName(MetadataHelper.getFullyQualifiedTableName(name, catalog, schema));
        mapping.setRelationTable(joinTable.getDatabaseTable());
        String defaultSourceFieldName = this.getReferenceDescriptor().hasManyToManyAccessorFor(this.getJavaClassName()) ? this.getReferenceDescriptor().getManyToManyAccessor(this.getJavaClassName()).getAttributeName() : Helper.getShortClassName(this.getJavaClass().getName());
        this.addManyToManyRelationKeyFields(joinTable.getJoinColumns(), mapping, defaultSourceFieldName, this.m_descriptor, true);
        String defaultTargetFieldName = this.getAttributeName();
        this.addManyToManyRelationKeyFields(joinTable.getInverseJoinColumns(), mapping, defaultTargetFieldName, this.getReferenceDescriptor(), false);
    }

    protected String processMapKey(CollectionMapping mapping) {
        String mapKey = null;
        if (this.isMapCollectionAccessor()) {
            MetadataDescriptor referenceDescriptor = this.getReferenceDescriptor();
            String mapKeyValue = this.getMapKey();
            if (!mapKeyValue.equals("") || !referenceDescriptor.hasCompositePrimaryKey()) {
                String string = referenceDescriptor.getIdAttributeName();
                this.getLogger();
                String fieldOrPropertyName = this.getName(mapKeyValue, string, "metadata_default_map_key_attribute_name");
                MetadataAccessor referenceAccessor = referenceDescriptor.getAccessorFor(fieldOrPropertyName);
                if (referenceAccessor == null) {
                    this.m_validator.throwCouldNotFindMapKey(fieldOrPropertyName, referenceDescriptor.getJavaClass(), mapping);
                }
                mapKey = referenceAccessor.getName();
            }
        }
        return mapKey;
    }

    protected void processOrderBy(CollectionMapping mapping) {
        block10: {
            if (!this.hasOrderBy()) break block10;
            String orderBy = this.getOrderBy();
            MetadataDescriptor referenceDescriptor = this.getReferenceDescriptor();
            if (orderBy.equals("")) {
                List<String> orderByAttributes = referenceDescriptor.getIdOrderByAttributeNames();
                if (referenceDescriptor.hasEmbeddedIdAttribute()) {
                    String embeddedIdAttributeName = referenceDescriptor.getEmbeddedIdAttributeName();
                    for (String orderByAttribute : orderByAttributes) {
                        mapping.addAggregateOrderBy(embeddedIdAttributeName, orderByAttribute, false);
                    }
                } else {
                    for (String orderByAttribute : orderByAttributes) {
                        mapping.addOrderBy(orderByAttribute, false);
                    }
                }
            } else {
                StringTokenizer commaTokenizer = new StringTokenizer(orderBy, ",");
                while (commaTokenizer.hasMoreTokens()) {
                    String ordering;
                    StringTokenizer spaceTokenizer = new StringTokenizer(commaTokenizer.nextToken());
                    String propertyOrFieldName = spaceTokenizer.nextToken();
                    MetadataAccessor referenceAccessor = referenceDescriptor.getAccessorFor(propertyOrFieldName);
                    if (referenceAccessor == null) {
                        this.m_validator.throwInvalidOrderByValue(this.getJavaClass(), propertyOrFieldName, referenceDescriptor.getJavaClass(), this.getName());
                    }
                    String attributeName = referenceAccessor.getAttributeName();
                    String string = ordering = spaceTokenizer.hasMoreTokens() ? spaceTokenizer.nextToken() : "ASC";
                    if (referenceAccessor.isEmbedded()) {
                        for (String orderByAttributeName : referenceDescriptor.getOrderByAttributeNames()) {
                            mapping.addAggregateOrderBy(attributeName, orderByAttributeName, ordering.equals("DESC"));
                        }
                        continue;
                    }
                    mapping.addOrderBy(attributeName, ordering.equals("DESC"));
                }
            }
        }
    }

    protected void setIndirectionPolicy(CollectionMapping mapping, String mapKey) {
        Class rawClass = this.getRawClass();
        if (this.usesIndirection()) {
            if (rawClass == Map.class) {
                mapping.useTransparentMap(mapKey);
            } else if (rawClass == List.class) {
                mapping.useTransparentList();
            } else if (rawClass == Collection.class) {
                mapping.useTransparentCollection();
                mapping.setContainerPolicy(new CollectionContainerPolicy(ClassConstants.IndirectList_Class));
            } else if (rawClass == Set.class) {
                mapping.useTransparentSet();
            }
        } else {
            mapping.dontUseIndirection();
            if (rawClass == Map.class) {
                mapping.useMapClass(Hashtable.class, mapKey);
            } else if (rawClass == Set.class) {
                mapping.useCollectionClass(HashSet.class);
            } else {
                mapping.useCollectionClass(Vector.class);
            }
        }
    }
}

