/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.web;

import org.apache.catalina.startup.Embedded;
import org.apache.catalina.Logger;
import org.apache.catalina.Engine;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.Container;

/*
 * Represents the production web container
 */
public class PwcWebContainer implements PwcWebContainerLifecycle {

    /**
     * The parent/top-level container in <code>_embedded</code> for virtual
     * servers.
     */
    private Engine _engine = null;

   /**
     * The embedded Catalina object.
     */
    private Embedded _embedded = null;


    /**
     * Has this component been started yet?
     */
    private boolean _started = false;

    public void onInitialization(String rootDir, String instanceName,
                                 boolean useNaming, Logger logger,
                                 String embeddedClassName) 
        throws Exception {
        Class c = Class.forName(embeddedClassName);
        _embedded = (Embedded) c.newInstance();
        _embedded.setUseNaming(useNaming);
        _embedded.setLogger(logger);
        _engine = _embedded.createEngine();
        _embedded.addEngine(_engine);
    }

    public void onStartup() 
        throws Exception {
        _started = true;

        _embedded.start();

    }

    public void onReady() 
        throws Exception {
    }

 
    public void onShutdown() 
        throws Exception {
    }


    public void onTermination() 
        throws Exception {
        _started = false;
        _embedded.stop();
    }

    public Engine getEngine() {
        return _engine;
    }

    public Embedded getEmbedded() {
        return _embedded;
    }

}
