/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.web.ias;


import com.sun.enterprise.tools.verifier.tests.web.elements.*;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

import com.sun.enterprise.tools.common.dd.EjbRef;
import com.sun.enterprise.tools.common.dd.webapp.*;


public class IASWebEjbRef extends WebTest implements WebCheck {



    public Result check(WebBundleDescriptor descriptor) {

	Result result = getInitializedResult();
	WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        EjbRef[] ejbRefs = descriptor.getIasWebApp().getEjbRef();

	boolean oneFailed = false;
        String jndiName;
        String refName;

    	if (ejbRefs.length > 0) {
            boolean isValidResRefName;
	    for (int rep=0; rep<ejbRefs.length; rep++ ) {
                //System.out.println(">>>>>>>>>>>>>rep is " + rep);
                isValidResRefName=false;

		jndiName = ejbRefs[rep].getJndiName();
                refName = ejbRefs[rep].getEjbRefName();

                if (validEjbRefName(refName,descriptor)) {
                    isValidResRefName=true;
                    result.addGoodDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
                    result.addGoodDetails(smh.getLocalString
					  (getClass().getName() + ".passed",
					   "Proper ejb reference name  [ {0} ] defined in the war file.",
					   new Object[] {refName}));
                } else {
                    if (!oneFailed)
                        oneFailed = true;
		    result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
                    result.addErrorDetails(smh.getLocalString
                                        (getClass().getName() + ".failed",
                                        "Error: Ejb reference name [ {0} ] is not valid, either empty or not defined in web.xml.",
                                        new Object[] {refName}));
                }

                if (isValidResRefName && validJndiName(jndiName, refName,descriptor)){
                    //                 foundIt  = true;
		    result.addGoodDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
                    result.addGoodDetails(smh.getLocalString
					  (getClass().getName() + ".passed",
					   "Proper jndi name  [ {0} ] defined in the war file.",
					   new Object[] {jndiName}));
                } else {
                    if (!oneFailed)
                        oneFailed = true;
		    result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
                    result.addErrorDetails(smh.getLocalString
                                        (getClass().getName() + ".failed",
                                        "Error: Jndi name [ {0} ] is not validis not valid, either empty or not starts with \"ejb/\".",
                                        new Object[] {jndiName}));
                }




	    }
	} else {
	    result.addNaDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "There is no ejb env reference element present in  this web archive [ {0} ].",
				  new Object[] {descriptor.getName()}));
	    return result;
	}

	if (oneFailed)
	    {
		result.setStatus(Result.FAILED);
	    } else {
		result.addGoodDetails(smh.getLocalString
                    ("tests.componentNameConstructor",
                    "For [ {0} ]",
                    new Object[] {compName.toString()}));
                result.passed
		    (smh.getLocalString
                    (getClass().getName() + ".passed",
                    "All ejb env reference elements are valid within the web archive [ {0} ].",
                    new Object[] {descriptor.getName()} ));
	    }
	return result;
    }


    boolean validEjbRefName(String name,WebBundleDescriptor descriptor){
        boolean valid =true;
        if(name !=null && name.length()!=0) {
            try{
              descriptor.getEjbReferenceByName(name);
            }
            catch(IllegalArgumentException e){
            valid=false;
            }
        }  else{
         valid=false;

        }
        return valid;
    }

    boolean validJndiName(String refJndiName, String refName,WebBundleDescriptor descriptor){
        boolean valid =true;

        if(refJndiName !=null && refJndiName.length()!=0 && refJndiName.startsWith("ejb/")) {

         }
        else{
        valid=false;
        }

        return valid;
    }


}


