/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.upgrade.common.arguments;

import com.sun.enterprise.tools.upgrade.common.ArgsParser;

/**
 *
 * @author Hans Hrasna
 */
public class ARG_domain extends ArgumentHandler {
    
    /** Creates a new instance of ARG_domain */
    public ARG_domain(ParsedArgument pa) {
        super(pa);       
        if (parameters.isEmpty()) {
            String msg = sm.getString("enterprise.tools.upgrade.cli.argument_missing", "--domain/-d");
            helpUsage(msg);
        }
        String domainName = (String)parameters.firstElement();
        if(!commonInfo.getDomainList().contains(domainName)){
            helpUsage();
            _logger.severe(sm.getString("enterprise.tools.upgrade.cli.domain_does_not_exist",domainName));
            System.exit(1);
        }
        interactiveMap.put(ArgsParser.DOMAIN + "-" + domainName,  domainName); //This is the encoding for the CLI interactive mode
        commonInfo.setCurrentDomain(domainName);
        commonInfo.addDomainOptionName(domainName);
        commonInfo.setCertificateConversionFlag(true);
    }
    
}
