/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * BooleanStringItemListener.java
 *
 * Created on March 18, 2001, 12:24 PM
 */

package com.sun.enterprise.tools.common;

import com.sun.enterprise.tools.common.util.diagnostics.Reporter;
/**
 *
 * @author  vkraemer
 * @version 
 */
public class BooleanStringItemListener implements java.awt.event.ItemListener {
    
    Object target = null;
    java.lang.reflect.Method writer = null;

        private Object args[] = { target };
    

    /** Creates new BooleanStringItemListener */
    public BooleanStringItemListener(Object target, String destName) throws  java.beans.IntrospectionException {
        this.target = target;
        writer = PropertyUtils.getWriter(target,destName);
    }
    
    public BooleanStringItemListener(Object target) {
        this.target = target;
    }

    private static final String FALSE[] =  {"false" };//NOI18N
    private static final String TRUE[] = { "true" };//NOI18N
    
    public void itemStateChanged(java.awt.event.ItemEvent itemEvent) {
        try {
            java.lang.reflect.Method lwriter = writer;
            if (null == lwriter) {
                java.awt.Component src = (java.awt.Component) itemEvent.getSource();
                lwriter = PropertyUtils.getWriter(target, src.getName());
            }
            Object args[] = FALSE;
            if (itemEvent.getStateChange() == java.awt.event.ItemEvent.SELECTED)
                args = TRUE;
            lwriter.invoke(target, args);
        }
        catch (Throwable t) {
            Reporter.critical(t); //NOI18N
        }
    }
    
}
