/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package javax.management.j2ee.statistics;

/**
 * Specifies the statistics provided by a JMS session. 
 *
 * @author Hans Hrasna
 */
public interface JMSSessionStats extends Stats {

     /**
     * Returns an array of JMSProducerStats that provide statistics about the message
     * producers associated with the referencing JMS session statistics.
     */
    JMSProducerStats[] getProducers();

    /**
     * Returns an array of JMSConsumerStats that provide statistics about the message
     * consumers associated with the referencing JMS session statistics. 
     */
    JMSConsumerStats[] getConsumers();

    /**
     * Number of messages exchanged. 
     */
    CountStatistic getMessageCount();

    /**
     * Number of pending messages. 
     */
    CountStatistic getPendingMessageCount();

    /**
     * Number of expired messages. 
     */
    CountStatistic getExpiredMessageCount();

    /**
     * Time spent by a message before being delivered. 
     */
    TimeStatistic getMessageWaitTime();

    /**
     * Number of durable subscriptions. 
     */
    CountStatistic getDurableSubscriptionCount();
}
