/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
//----------------------------------------------------------------------------
//
// Module:      EventSemaphore.java
//
// Description: Event semaphore implementation.
//
// Product:     com.sun.jts.CosTransactions
//
// Author:      Simon Holdsworth
//
// Date:        March, 1997
//
// Copyright (c):   1995-1997 IBM Corp.
//
//   The source code for this program is not published or otherwise divested
//   of its trade secrets, irrespective of what has been deposited with the
//   U.S. Copyright Office.
//
//   This software contains confidential and proprietary information of
//   IBM Corp.
//----------------------------------------------------------------------------

package com.sun.jts.CosTransactions;

/**The EventSemaphore interface provides operations that wait for and post an
 * event semaphore.
 * <p>
 * This is specifically to handle the situation where the event may have been
 * posted before the wait method is called.  This behaviour is not supported by
 * the existing wait and notify methods.
 *
 * @version 0.01
 *
 * @author Simon Holdsworth, IBM Corporation
 *
 * @see
*/
//----------------------------------------------------------------------------
// CHANGE HISTORY
//
// Version By     Change Description
//   0.01  SAJH   Initial implementation.
//-----------------------------------------------------------------------------

public class EventSemaphore {
    boolean posted = false;

    /**Default EventSemaphore constructor.
     *
     * @param
     *
     * @return
     *
     * @see
     */
    EventSemaphore() {
    }

    /**Creates the event semaphore in the given posted state.
     *
     * @param posted  Indicates whether the semaphore should be posted.
     *
     * @return
     *
     * @see
     */
    EventSemaphore( boolean posted ) {
        this.posted = posted;
    }

    /**
     * @return true if semaphore has already been posted.
     */
    synchronized public boolean isPosted() {
        return posted;
    }

    /**Waits for the event to be posted.
     * <p>
     * If the event has already been posted, then the operation returns immediately.
     *
     * @param
     *
     * @return
     *
     * @exception InterruptedException  The wait was interrupted.
     *
     * @see
     */
    synchronized public void waitEvent()
        throws InterruptedException {
        if( !posted )
            wait();
    }

    /**Posts the event semaphore.
     * <p>
     * All waiters are notified.
     *
     * @param
     *
     * @return
     *
     * @see
     */
    synchronized void post() {
        if( !posted )
            notifyAll();
        posted = true;
    }

    /**Clears a posted event semaphore.
     *
     * @param
     *
     * @return
     *
     * @see
     */
    synchronized void clear() {
        posted = false;
    }
}
