/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.transaction.base;

import oracle.toplink.essentials.exceptions.TransactionException;
import oracle.toplink.essentials.internal.ejb.cmp3.base.*;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;

public abstract class TransactionWrapperImpl  {

    protected EntityManagerImpl entityManager = null;
        
    //This attribute will store a reference to the non transactional UnitOfWork used
    // for queries outside of a transaction
    protected RepeatableWriteUnitOfWork localUOW;
        
    //used to cache the transactional UnitOfWork so that we do not need to look it up each time.
    protected Object txnKey;
    
    
    public TransactionWrapperImpl(EntityManagerImpl entityManager){
        this.entityManager = entityManager;
    }
        
    /**
     * INTERNAL:
     * This method will be used to check for a transaction and throws exception if none exists.
     * If this methiod returns without exception then a transaction exists.
     * This method must be called before accessing the localUOW.
     */
    public abstract Object checkForTransaction(boolean validateExistence);
 
    /**
     * INTERNAL:
     * Clears the transactional UnitOfWork
     */
    public void clear(){
        if (this.localUOW != null){
            this.localUOW.clear();
        }
    }
    
    /**
     * INTERNAL:
     * THis method is used to get the active UnitOfWork.  It is special in that it will
     * return the required RepeatableWriteUnitOfWork required by the EntityManager.  Once
     * RepeatableWrite is merged into existing UnitOfWork this code can go away.
     * @param transaction
     * @return
     */
    public abstract RepeatableWriteUnitOfWork getTransactionalUnitOfWork(Object transaction);

    public abstract void registerUnitOfWorkWithTxn(UnitOfWorkImpl uow);
    
    public UnitOfWorkImpl getLocalUnitOfWork(){
        return localUOW;
    }

    public void setLocalUnitOfWork(RepeatableWriteUnitOfWork uow){
        this.localUOW = uow;
    }

    /**
    * Mark the current transaction so that the only possible
    * outcome of the transaction is for the transaction to be
    * rolled back.
    * @throws IllegalStateException if isActive() is false.
    */
    public void setRollbackOnlyInternal(){
        //No -op for most wrappers as TopLink will mark for rollback in the case
        //of external transaction controller
    }
    
    /**
     * This method will be called when an entity manager attempts to close to verify its
     * transaction is in a closable state.
     */
    public abstract boolean shouldClose();
    
    /**
     * This method will be called when a query is executed.  If changes in the entity manager
     * should be flushed this method should return true
     */
    public abstract boolean shouldFlushBeforeQuery(UnitOfWorkImpl uow);
    
    /**
     * These two method used for closing of EntityManager in case there is a transaction in progress:
     * The first method is called by EntityManager.close method to mark the current transaction,
     * the second one is called by EntityManager.verifyOpen method.
     */
    public abstract void markLastTransaction();
    public abstract boolean hasLastTransactionCompleted();
}
