/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns;

import javax.persistence.JoinColumn;

import oracle.toplink.essentials.internal.helper.DatabaseField;

/**
 * Object to hold onto join column metadata in a TopLink database fields.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class MetadataJoinColumn {
    protected DatabaseField m_pkField;
    protected DatabaseField m_fkField;
    
    public static final String DEFAULT_NAME = "";
    public static final String DEFAULT_TABLE = "";
    public static final String DEFAULT_COLUMN_DEFINITION = "";
    public static final String DEFAULT_REFERENCED_COLUMN_NAME = "";
    
    public static final boolean DEFAULT_UNIQUE = false;
    public static final boolean DEFAULT_NULLABLE = true;
    public static final boolean DEFAULT_UPDATABLE = true;
    public static final boolean DEFAULT_INSERTABLE = true;
    
    /**
     * INTERNAL:
     */
    public MetadataJoinColumn() {
        m_pkField = new DatabaseField();
        m_pkField.setName(DEFAULT_REFERENCED_COLUMN_NAME);
        
        m_fkField = new DatabaseField();
        m_fkField.setName(DEFAULT_NAME);
        m_fkField.setTableName(DEFAULT_TABLE);
        m_fkField.setUnique(DEFAULT_UNIQUE);
        m_fkField.setNullable(DEFAULT_NULLABLE);
        m_fkField.setUpdatable(DEFAULT_UPDATABLE);
        m_fkField.setInsertable(DEFAULT_INSERTABLE);
        m_fkField.setColumnDefinition(DEFAULT_COLUMN_DEFINITION);
    }
    
    /**
     * INTERNAL:
     * Called for association override.
     */
    public MetadataJoinColumn(JoinColumn joinColumn) {
        this();
        
        if (joinColumn != null) {
            // Process the primary key field metadata.
            m_pkField.setName(joinColumn.referencedColumnName());
        
            // Process the foreign key field metadata.
            m_fkField.setName(joinColumn.name());
            m_fkField.setTableName(joinColumn.table());
            m_fkField.setUnique(joinColumn.unique());
            m_fkField.setNullable(joinColumn.nullable());
            m_fkField.setUpdatable(joinColumn.updatable());
            m_fkField.setInsertable(joinColumn.insertable());
            m_fkField.setColumnDefinition(joinColumn.columnDefinition());
        }
    }
    
    /**
     * INTERNAL:
     */
    public DatabaseField getForeignKeyField() {
        return m_fkField;
    }
    
    /**
     * INTERNAL:
     */
    public DatabaseField getPrimaryKeyField() {
        return m_pkField;
    }
    
    /**
     * INTERNAL:
     */
    public boolean isForeignKeyFieldNotSpecified() {
        return m_fkField.getName().equals("");
    }
    
    /**
     * INTERNAL:
     */
    public boolean isPrimaryKeyFieldNotSpecified() {
        return m_pkField.getName().equals("");
    }
    
    /**
     * INTERNAL:
     */
    public boolean loadedFromXML() {
        return false;
    }
}
