
/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package javax.enterprise.deploy.model;

import javax.enterprise.deploy.shared.ModuleType;

/**
 * An interface that represents the root of a standard deployment 
 * descriptor.  A DDBeanRoot is a type of DDBean.
 *
 * @author gfink
 */
public interface DDBeanRoot extends DDBean {
    
    /**
     * Return the ModuleType of deployment descriptor.
     *
     * @return The ModuleType of deployment descriptor
     */   
   public ModuleType getType();
   
   /**
    * Return the containing DeployableObject
    * @return The DeployableObject that contains this
    *           deployment descriptor
    */   
   public DeployableObject getDeployableObject();
   
   /**
    * A convenience method to return the DTD version number.
    * The DeployableObject has this information.
    * @return a string containing the DTD version number
    *
    * This method is being deprecated. Two DD data formats
    * are being used, DTD and XML Schema.  DDBeanRoot.getDDBeanRootVersion
    * should be used in its place.
    *
    * @deprecated As of version 1.1 replaced by 
    * DDBeanRoot.getDDBeanRootVersion()
    */
   public String getModuleDTDVersion();

   /** 
    * Returns the version number of an XML instance document.
    * This method is replacing the methods DDBeanRoot.getModuleDTDVersion 
    * and DeployableObject.getModuleDTDVersion. This method returns 
    * the version number of any J2EE XML instance document. 
    *
    * @return a string that is the version number of the XML instance 
    *   document. Null is returned if no version number can be found. 
    */ 
   public String getDDBeanRootVersion(); 

    /**
     * Return the XPath for this standard bean.
     * The root XPath is "/".
     * @return "/" this is the root standard bean.
     */
    public String getXpath();

    /**
     * Returns the filename relative to the root of the module 
     * of the XML instance document this DDBeanRoot represents. 
     *
     * @return String the filename relative to the root of the module 
     */ 
   public String getFilename(); 
}

