/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * AbstractLoggerFactory.java
 *
 * Created on May 13, 2002, 10:15 PM
 */

package com.sun.jdo.spi.persistence.utility.logging;

import java.util.Map;
import java.util.HashMap;

/** 
 *
 * @author Rochelle Raccah
 * @version %I%
 */
abstract public class AbstractLoggerFactory implements LoggerFactory
{
	private final static String _domainPrefix = "com.sun.jdo."; //NOI18N

	private final static Map _loggerCache = new HashMap();

	private static final String _bundleName =
		"com.sun.jdo.spi.persistence.utility.logging.Bundle"; // NOI18N


	/** Get the error logger which is used to log things during creation of 
	 * loggers.
	 */
	protected static Logger getErrorLogger () 
	{
		return LogHelper.getLogger("", _bundleName,  // NOI18N
			AbstractLoggerFactory.class.getClassLoader());
	}

	/** Get a Logger.  The class that implements this interface is responsible
	 * for creating a logger for the named component.
	 * The bundle name and class loader are passed to allow the implementation
	 * to properly find and construct the internationalization bundle.
	 * @param relativeLoggerName the relative name of this logger
	 * @param bundleName the fully qualified name of the resource bundle
	 * @param loader the class loader used to load the resource bundle, or null
	 * @return the logger
	 */
	public synchronized Logger getLogger (String relativeLoggerName, 
		String bundleName, ClassLoader loader)
	{
		String absoluteLoggerName = getAbsoluteLoggerName(relativeLoggerName);
		Logger value = (Logger)_loggerCache.get(absoluteLoggerName);

		if (value == null)
		{
			value = createLogger(absoluteLoggerName, bundleName, loader);

			if (value != null)
				_loggerCache.put(absoluteLoggerName, value);
		}

		return value;
	}

	/** Create a new Logger.  Subclasses are responsible for creating a 
	 * logger for the named component.  The bundle name and class loader 
	 * are passed to allow the implementation to properly find and 
	 * construct the internationalization bundle.
	 * @param absoluteLoggerName the absolute name of this logger
	 * @param bundleName the fully qualified name of the resource bundle
	 * @param loader the class loader used to load the resource bundle, or null
	 * @return the logger
	 */
	abstract protected Logger createLogger (String absoluteLoggerName, 
		String bundleName, ClassLoader loader);

	protected String getDomainRoot () { return _domainPrefix; }

	protected String getAbsoluteLoggerName (String relativeLoggerName)
	{
		return (relativeLoggerName.startsWith("java") ?			//NOI18N
			relativeLoggerName : (getDomainRoot() + relativeLoggerName));
	}
}
