/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import com.sun.jdo.spi.persistence.support.sqlstore.RetrieveDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStoreManager;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;

import java.util.List;

/**
 * Implements the select plan for In-Subqueries.
 *
 * @author Markus Fuchs
 * @author Mitesh Meswani
 */
public class CorrelatedInSelectPlan extends CorrelatedSelectPlan {

    public CorrelatedInSelectPlan(RetrieveDesc desc,
                                  SQLStoreManager store,
                                  ForeignFieldDesc parentField,
                                  SelectQueryPlan parentPlan) {

        super(desc, store, parentField, parentPlan);
    }

    /**
     * Add the fields joining the subquery to the list of selected fields.
     * The joined table is added as a side-effect.
     */
    protected void processFields() {
        List subqueryFieldsToSelect;

        if (parentField.useJoinTable()) {
            subqueryFieldsToSelect = parentField.getAssocLocalFields();
        } else {
            subqueryFieldsToSelect = parentField.getForeignFields();
        }

        // Add the columns and tables to be selected in the subquery
        for (int i = 0; i < subqueryFieldsToSelect.size(); i++) {
            addColumn((LocalFieldDesc) subqueryFieldsToSelect.get(i));
        }
    }

    /**
     * No-Op. No join condition is added for correlated in selects,
     * as the queries are joined on the selected fields.
     */
    protected void doCorrelatedJoin() {}

}
