/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Field.java
 *
 * Created on March 21, 2001
 */

package com.sun.jdo.spi.persistence.support.sqlstore.query.util.scope;

import com.sun.jdo.spi.persistence.utility.I18NHelper; 

import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.Type;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.FieldInfo;

/**
 * An object of class Field is used if an identifier
 * denotes a field.
 *
 * @author  Michael Bouschen
 * @version 0.1
 */
public class Field
  extends Definition
{
    /**
     * The corresponding field info.
     */
    protected FieldInfo fieldInfo;

    /**
     *
     */
    public Field(FieldInfo fieldInfo)
    {
        super(fieldInfo.getType());
        this.fieldInfo = fieldInfo;
    }
	
    /**
     *
     */
	public String getName()
	{
		return I18NHelper.getMessage(messages, "scope.field.getname.name"); //NOI18N
	}

    /**
     * Returns the corresponding field info.
     */
    public FieldInfo getFieldInfo()
    {
        return fieldInfo;
    }

    /**
     *
     */
    public String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append("Field("); //NOI18N
        buf.append(scope);
        buf.append(", "); //NOI18N
        buf.append(type);
        buf.append(")"); //NOI18N
        return buf.toString();
    }
}
