/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * MappingElement.java
 *
 * Created on March 3, 2000, 1:11 PM
 */

package com.sun.jdo.api.persistence.model.mapping;

import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;

import com.sun.jdo.api.persistence.model.ModelException;

/** 
 *
 * @author raccah
 * @version %I%
 */
public interface MappingElement extends MappingElementProperties, Comparable
{
	/** Add a property change listener.
	 * @param l the listener to add
	 */
	public void addPropertyChangeListener (PropertyChangeListener l);

	/** Remove a property change listener.
	 * @param l the listener to remove
	 */
	public void removePropertyChangeListener (PropertyChangeListener l);

	/** Add a vetoable change listener.
	 * @param l the listener to add
	 */
	public void addVetoableChangeListener (VetoableChangeListener l);

	/** Remove a vetoable change listener.
	 * @param l the listener to remove
	 */
	public void removeVetoableChangeListener (VetoableChangeListener l);

	/** Get the name of this mapping element.
	 * @return the name
	 */
	public String getName ();

	/** Set the name of this mapping element.
	 * @param name the name
	 * @exception ModelException if impossible
	 */
    public void setName (String name) throws ModelException;
}
