/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * FieldGroupElementImpl.java
 *
 * Created on March 2, 2000, 6:28 PM
 */
 
package com.sun.jdo.api.persistence.model.jdo.impl;

import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.jdo.FieldGroupElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;

/** 
 *
 * @author  raccah
 * @version %I%
 */
public class FieldGroupElementImpl extends PersistenceMemberElementImpl 
	implements FieldGroupElement.Impl
{
	/** Fields of the field group element. */
	private PersistenceElementCollection _fields;

	/** Create new FieldGroupElementImpl with no corresponding name.  This 
	 * constructor should only be used for cloning and archiving.
	 */
	public FieldGroupElementImpl ()
	{
		this(null);
	}

	/** Creates new FieldGroupElementImpl with the corresponding name 
	 * @param name the name of the element
	 */
	public FieldGroupElementImpl (String name)
	{
		super(name);
		_fields = new PersistenceElementCollection(this, PROP_FIELDS, 
			new PersistenceFieldElement[0]);
	}

	/** Find a field by name.
	 * @param name the name to match
	 * @return the field, or <code>null</code> if it does not exist
	 */
	public PersistenceFieldElement getField (String name)
	{
		return (PersistenceFieldElement)_fields.getElement(name);
	}

	/** Get all fields.
	 * @return the fields
	 */
	public PersistenceFieldElement[] getFields ()
	{
		return (PersistenceFieldElement[])_fields.getElements();
	}


	/** Change the set of fields.
	 * @param fields the new fields
	 * @param action {@link #ADD}, {@link #REMOVE}, or {@link #SET}
	 * @exception ModelException if impossible
	 */
	public void changeFields (PersistenceFieldElement[] fields, int action)
		throws ModelException
	{
		_fields.changeElements(fields, action);
	}

	//=============== extra methods needed for xml archiver ==============

	/** Returns the field collection of this field group element.  This 
	 * method should only be used internally and for cloning and archiving.
	 * @return the field collection of this field group element
	 */
	public PersistenceElementCollection getCollection () { return _fields; }

	/** Set the field collection of this field group element to the supplied 
	 * collection.  This method should only be used internally and for 
	 * cloning and archiving.
	 * @param collection the field collection of this field group element
	 */
	public void setCollection (PersistenceElementCollection collection)
	{
		_fields = collection;
	}
}
