/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.classfile;

import java.io.*;

//@olsen: fix 4467428, added class for synthetic attribute to be added
// to generated jdo fields and methods

/**
 * SyntheticAttribute represents a constant value attribute 
 * in a class file.  These attributes are used as initialization
 * values for static fields.
 */

public class SyntheticAttribute extends ClassAttribute {
  /* The expected name of this attribute */
  public static final String expectedAttrName = "Synthetic";//NOI18N

  /** 
   * Construct a constant value attribute
   */
  public SyntheticAttribute(ConstUtf8 attrName) {
    super(attrName);
    //System.out.println("new SyntheticAttribute()");
  }

  /* package local methods */

  static SyntheticAttribute read (ConstUtf8 attrName,
                                  DataInputStream data,
                                  ConstantPool pool)
    throws IOException {
    return new SyntheticAttribute(attrName);
  }

  void write(DataOutputStream out) throws IOException {
    out.writeShort(attrName().getIndex());
    final int attributeBytesLength = 0;
    out.writeInt(attributeBytesLength);
  }

  void print(PrintStream out, int indent) {
    ClassPrint.spaces(out, indent);
    out.println(expectedAttrName);
  }
}
