/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.classfile;

import java.io.PrintStream;

/**
 * Special instruction form for the opc_invokeinterface instruction
 */

public class InsnInterfaceInvoke extends InsnConstOp {
  /* The number of arguments to the interface method */
  private int nArgsOp;

  /* public accessors */

  public int nStackArgs() {
    return super.nStackArgs();
  }

  public int nStackResults() {
    return super.nStackResults();
  }

  /**
   * What are the types of the stack operands ?
   */
  public String argTypes() {
    return super.argTypes();
  }

  /**
   * What are the types of the stack results?
   */
  public String resultTypes() {
    return super.resultTypes();
  }

  public boolean branches() {
    return false;
  }

  /**
   * Return the interface to be invoked
   */
  public ConstInterfaceMethodRef method() {
    return (ConstInterfaceMethodRef) value();
  }

  /**
   * Return the number of arguments to the interface
   */
  public int nArgs() {
    return nArgsOp;
  }

  /**
   * constructor for opc_invokeinterface
   */
  public InsnInterfaceInvoke (ConstInterfaceMethodRef methodRefOp, 
			      int nArgsOp) {
    this(methodRefOp, nArgsOp, NO_OFFSET);
  }

  /* package local methods */

  InsnInterfaceInvoke (ConstInterfaceMethodRef methodRefOp, int nArgsOp,
		       int offset) {
    super(opc_invokeinterface, methodRefOp, offset);

    this.nArgsOp = nArgsOp; 

    if (methodRefOp == null || nArgsOp < 0)
	throw new InsnError ("attempt to create an opc_invokeinterface" +//NOI18N
			     " with invalid operands");//NOI18N
  }

  void print (PrintStream out, int indent) {
    ClassPrint.spaces(out, indent);
    out.println(offset() + "  opc_invokeinterface  " + //NOI18N
		"pool(" + method().getIndex() + ")," + nArgsOp);//NOI18N
  }

  int store(byte[] buf, int index) {
    buf[index++] = (byte) opcode();
    index = storeShort(buf, index, (short)method().getIndex());
    buf[index++] = (byte) nArgsOp;
    buf[index++] = (byte) 0;
    return index;
  }

  int size() {
    return 5;
  }

  static InsnInterfaceInvoke read(InsnReadEnv insnEnv, int myPC) {
    ConstInterfaceMethodRef iface = (ConstInterfaceMethodRef)
      insnEnv.pool().constantAt(insnEnv.getUShort());
    int nArgs = insnEnv.getUByte();
    insnEnv.getByte(); // eat reserved arg
    return new InsnInterfaceInvoke(iface, nArgs, myPC);
  }
}
