/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.classfile;


import java.io.PrintStream;

/**
 * Special instruction form for the opc_iinc instruction
 */

public class InsnIInc extends Insn {

  /* The local variable slot to be incremented */
  private int localVarIndex;

  /* The amount by which the slot is to be incremented */
  private int value;

  /* public accessors */

  public int nStackArgs() {
    return 0;
  }

  public int nStackResults() {
    return 0;
  }

  /**
   * What are the types of the stack operands ?
   */
  public String argTypes() {
      return "";//NOI18N
  }

  /**
   * What are the types of the stack results?
   */
  public String resultTypes() {
      return "";//NOI18N
  }

  public boolean branches() {
    return false;
  }

  /**
   * The local variable slot to be incremented
   */
  public int varIndex() {
    return localVarIndex;
  }

  /**
   * The amount by which the slot is to be incremented 
   */
  public int incrValue() {
    return value;
  }
  
  /**
   * Constructor for opc_iinc instruction
   */
  public InsnIInc (int localVarIndex, int value) {
    this(localVarIndex, value, NO_OFFSET);
  }

  /* package local methods */

  InsnIInc (int localVarIndex, int value, int pc) {
    super(opc_iinc, pc);

    this.localVarIndex = localVarIndex;
    this.value =value;
  }

  void print (PrintStream out, int indent) {
    ClassPrint.spaces(out, indent);
    out.println(offset() + "  opc_iinc  " + //NOI18N
		localVarIndex + "," + value);//NOI18N
  }

  int store(byte[] buf, int index) {
    if (isWide())
      buf[index++] = (byte) opc_wide;
    buf[index++] = (byte) opcode();
    if (isWide()) {
      index = storeShort(buf, index, (short) localVarIndex);
      index = storeShort(buf, index, (short) value);
    } else {
      buf[index++] = (byte)localVarIndex;
      buf[index++] = (byte)value;
    }
    return index;
  }

  int size() {
    return isWide() ? 6 : 3;
  }

  private boolean isWide() {
    return (value > 127 || value < -128 || localVarIndex > 255);
  }

}
