/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.classfile;

import java.io.*;

/**
 * The abstract base class used to represent the various type of
 * references to members (fields/methods) within the constant pool. 
 */

public abstract class ConstBasicMemberRef extends ConstBasic {
  /* The name of the class on which the member is defined */
  protected ConstClass theClassName;

  /* The index of the class on which the member is defined
   *   - used temporarily while reading from a class file */
  protected int theClassNameIndex;

  /* The name and type of the member */
  protected ConstNameAndType theNameAndType;

  /* The index of the name and type of the member
   *   - used temporarily while reading from a class file */
  protected int theNameAndTypeIndex;

  /* public accessors */

  /**
   * Return the name of the class defining the member 
   */
  public ConstClass className() {
    return theClassName;
  }

  /**
   * Return the name and type of the member 
   */
  public ConstNameAndType nameAndType() {
    return theNameAndType;
  }

  public String toString () {
      return "className(" + theClassName.toString() + ")" +//NOI18N
          " nameAndType(" + theNameAndType.toString() + ")";//NOI18N
  }

  /* package local methods */

  /**
   * Constructor for "from scratch" creation
   */
  ConstBasicMemberRef (ConstClass cname, ConstNameAndType NT) {
    theClassName = cname;
    theNameAndType = NT;
  }

  /**
   * Constructor for reading from a class file
   */
  ConstBasicMemberRef (int cnameIndex, int NT_index) {
    theClassNameIndex = cnameIndex;
    theNameAndTypeIndex = NT_index;
  }

  void formatData (DataOutputStream b) throws IOException {
    b.writeShort(theClassName.getIndex());
    b.writeShort(theNameAndType.getIndex());
  }
  void resolve (ConstantPool p) {
    theClassName = (ConstClass) p.constantAt(theClassNameIndex);
    theNameAndType = (ConstNameAndType) p.constantAt(theNameAndTypeIndex);
  }
}

