/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.TagLibDescriptor;
import com.sun.enterprise.tools.verifier.web.TagDescriptor;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.deployment.WebBundleDescriptor;

/**
 * dynamic-attributes element in tag element describes whether this tag supports
 * additional attributes with dynamic names. If true, the tag-class must
 * implement the javax.servlet.jsp.tagext.DynamicAttributes interface.
 * Defaults to false.
 * @author Sudipto Ghosh
 *
 */
public class TagClassImplementsValidInterface extends WebTest implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {

        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        Context context = getVerifierContext();
        Result result = getInitializedResult();
        ClassLoader cl = context.getClassLoader();
        TagLibDescriptor tlds[] = context.getTagLibDescriptors();
        if (tlds == null) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                    (getClass().getName() + ".passed",
                            "No tag lib files are specified"));
            return result;
        }

        for (TagLibDescriptor tld : tlds) {
            if (tld.getSpecVersion().compareTo("2.0")>=0) {
                for (TagDescriptor tagdesc : tld.getTagDescriptors()) {
                    Class c = null;
                    try {
                        c = Class.forName(tagdesc.getTagClass(), false, cl);
                    } catch (ClassNotFoundException e) {
                       //do nothing
                    }
                    if (tagdesc.getDynamicAttributes().equalsIgnoreCase("true") &&
                            !javax.servlet.jsp.tagext.DynamicAttributes.class.
                            isAssignableFrom(c) ) {
                        addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(getClass()
                                .getName() +
                                ".failed",
                                "Error: tag class [ {0} ] in [ {1} ] does not " +
                                "implements interface " +
                                "javax.servlet.jsp.tagext.DynamicAttributes",
                                new Object[]{c.getName(), tld.getUri()}));

                    }
                }
            }
        }

        if(result.getStatus() != Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString(getClass()
                                    .getName() +
                    ".passed1", "All tag-class defined in the tag lib descriptor" +
                    " files implement valid interface"));
        }
        return result;
    }
}
